/*
 * Decompiled with CFR 0.152.
 */
package mc.algrim.fabric.chat.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mc.algrim.fabric.chat.AlgrimChat;
import mc.algrim.fabric.chat.config.option.PatternOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\n8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00178&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lmc/algrim/fabric/chat/config/ConfigFile;", "Lfi/dy/masa/malilib/config/IConfigHandler;", "Ljava/io/File;", "configFile", "<init>", "(Ljava/io/File;)V", "", "load", "()V", "save", "", "fileVersion", "Lcom/google/gson/JsonObject;", "root", "handleUpdate", "(ILcom/google/gson/JsonObject;)Lcom/google/gson/JsonObject;", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "version", "I", "getVersion", "()I", "", "", "", "Lfi/dy/masa/malilib/config/IConfigBase;", "getCategories", "()Ljava/util/Map;", "categories", "algrim-chat"})
public abstract class ConfigFile
implements IConfigHandler {
    @NotNull
    private final File configFile;
    private final int version;

    public ConfigFile(@NotNull File configFile) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        this.configFile = configFile;
        this.version = 2;
    }

    @NotNull
    public final File getConfigFile() {
        return this.configFile;
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public abstract Map<String, List<IConfigBase>> getCategories();

    public void load() {
        JsonElement element;
        if (this.configFile.exists() && this.configFile.isFile() && this.configFile.canRead() && (element = JsonUtils.parseJsonFile((File)this.configFile)) != null && element.isJsonObject()) {
            int fileVersion;
            JsonObject root = element.getAsJsonObject();
            JsonPrimitive versionJson = root.getAsJsonPrimitive("version");
            int n = fileVersion = versionJson == null || !versionJson.isNumber() ? -1 : versionJson.getAsNumber().intValue();
            if (fileVersion < this.getVersion()) {
                JsonObject jsonObject = root;
                Intrinsics.checkNotNull((Object)jsonObject);
                root = this.handleUpdate(fileVersion, jsonObject);
            }
            for (Map.Entry entry : this.getCategories().entrySet()) {
                String category = (String)entry.getKey();
                List options = (List)entry.getValue();
                ConfigUtils.readConfigBase((JsonObject)root, (String)category, (List)options);
            }
        }
    }

    public void save() {
        AlgrimChat.getLogger().info("Saving config to " + this.configFile);
        if (this.configFile.getParentFile().exists() && this.configFile.getParentFile().isDirectory() || this.configFile.getParentFile().mkdirs()) {
            JsonObject root = new JsonObject();
            for (Map.Entry<String, List<IConfigBase>> entry : this.getCategories().entrySet()) {
                String category = entry.getKey();
                List<IConfigBase> options = entry.getValue();
                ConfigUtils.writeConfigBase((JsonObject)root, (String)category, options);
            }
            root.addProperty("version", (Number)this.getVersion());
            JsonUtils.writeJsonToFile((JsonObject)root, (File)this.configFile);
        }
    }

    @NotNull
    public JsonObject handleUpdate(int fileVersion, @NotNull JsonObject root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (fileVersion < 2) {
            JsonObject jsonObject = JsonUtils.getNestedObject((JsonObject)root, (String)"Chat", (boolean)false);
            if (jsonObject == null) {
                return root;
            }
            JsonObject chatObj = jsonObject;
            JsonArray patternsJson = chatObj.getAsJsonArray("patterns");
            JsonArray newPatternsJson = new JsonArray();
            Iterator iterator = patternsJson.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                JsonElement patternJson = (JsonElement)iterator2.next();
                if (!patternJson.isJsonPrimitive()) continue;
                JsonObject patternOption = new JsonObject();
                String patternVal = patternJson.getAsString();
                patternOption.addProperty(PatternOption.PropertyName.NAME.getJsonName(), "");
                patternOption.addProperty(PatternOption.PropertyName.PATTERN.getJsonName(), patternVal);
                patternOption.addProperty(PatternOption.PropertyName.ENABLED.getJsonName(), Boolean.valueOf(true));
                newPatternsJson.add((JsonElement)patternOption);
            }
            chatObj.add("patterns", (JsonElement)newPatternsJson);
        }
        return root;
    }
}

