/*
 * Decompiled with CFR 0.152.
 */
package mc.algrim.fabric.chat.config.option;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.options.ConfigBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mc.algrim.fabric.chat.AlgrimChat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001d\u001eB'\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lmc/algrim/fabric/chat/config/option/PatternOption;", "Lfi/dy/masa/malilib/config/options/ConfigBase;", "", "name", "comment", "prettyName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lcom/google/gson/JsonElement;", "element", "", "setValueFromJsonElement", "(Lcom/google/gson/JsonElement;)V", "getAsJsonElement", "()Lcom/google/gson/JsonElement;", "", "isModified", "()Z", "resetToDefault", "()V", "", "Lmc/algrim/fabric/chat/config/option/PatternOption$PatternOptionValue;", "value", "patternOptionValues", "Ljava/util/List;", "getPatternOptionValues", "()Ljava/util/List;", "setPatternOptionValues", "(Ljava/util/List;)V", "PatternOptionValue", "PropertyName", "algrim-chat"})
public final class PatternOption
extends ConfigBase<PatternOption> {
    @NotNull
    private List<PatternOptionValue> patternOptionValues;

    public PatternOption(@Nullable String name, @Nullable String comment, @Nullable String prettyName) {
        super(ConfigType.STRING_LIST, name, comment, prettyName);
        this.patternOptionValues = CollectionsKt.emptyList();
    }

    public /* synthetic */ PatternOption(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        this(string, string2, string3);
    }

    @NotNull
    public final List<PatternOptionValue> getPatternOptionValues() {
        return this.patternOptionValues;
    }

    public final void setPatternOptionValues(@NotNull List<PatternOptionValue> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.patternOptionValues = value;
        this.onValueChanged();
    }

    public void setValueFromJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!element.isJsonArray()) {
            AlgrimChat.getLogger().error("Failed to deserialize option '" + this.getName() + "', '" + element + "' is not an array!");
            return;
        }
        JsonArray root = element.getAsJsonArray();
        List values = new ArrayList();
        Iterator iterator = root.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement rootElement = (JsonElement)iterator2.next();
            try {
                JsonObject optionObj = rootElement.getAsJsonObject();
                String name = optionObj.getAsJsonPrimitive(PropertyName.NAME.getJsonName()).getAsString();
                String patternValue = optionObj.getAsJsonPrimitive(PropertyName.PATTERN.getJsonName()).getAsString();
                boolean enabled = optionObj.getAsJsonPrimitive(PropertyName.ENABLED.getJsonName()).getAsBoolean();
                Intrinsics.checkNotNull((Object)name);
                Intrinsics.checkNotNull((Object)patternValue);
                values.add(new PatternOptionValue(name, patternValue, enabled));
            }
            catch (IllegalStateException e) {
                AlgrimChat.getLogger().error("Failed to deserialize pattern value in option '" + this.getName() + "', '" + rootElement + "'!");
            }
        }
        this.setPatternOptionValues(values);
    }

    @NotNull
    public JsonElement getAsJsonElement() {
        JsonArray root = new JsonArray();
        for (PatternOptionValue optionValue : this.patternOptionValues) {
            JsonObject optionObj = new JsonObject();
            optionObj.addProperty(PropertyName.NAME.getJsonName(), optionValue.getName());
            optionObj.addProperty(PropertyName.PATTERN.getJsonName(), optionValue.getPatternValue());
            optionObj.addProperty(PropertyName.ENABLED.getJsonName(), Boolean.valueOf(optionValue.getEnabled()));
            root.add((JsonElement)optionObj);
        }
        return (JsonElement)root;
    }

    public boolean isModified() {
        return !((Collection)this.patternOptionValues).isEmpty();
    }

    public void resetToDefault() {
        this.setPatternOptionValues(CollectionsKt.emptyList());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000b\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lmc/algrim/fabric/chat/config/option/PatternOption$PatternOptionValue;", "", "", "name", "patternValue", "", "enabled", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "withEnabled", "(Z)Lmc/algrim/fabric/chat/config/option/PatternOption$PatternOptionValue;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "getPatternValue", "Z", "getEnabled", "()Z", "algrim-chat"})
    public static final class PatternOptionValue {
        @NotNull
        private final String name;
        @NotNull
        private final String patternValue;
        private final boolean enabled;

        public PatternOptionValue(@NotNull String name, @NotNull String patternValue, boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)patternValue, (String)"patternValue");
            this.name = name;
            this.patternValue = patternValue;
            this.enabled = enabled;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getPatternValue() {
            return this.patternValue;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final PatternOptionValue withEnabled(boolean enabled) {
            return new PatternOptionValue(this.name, this.patternValue, enabled);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lmc/algrim/fabric/chat/config/option/PatternOption$PropertyName;", "", "", "jsonName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getJsonName", "()Ljava/lang/String;", "NAME", "PATTERN", "ENABLED", "algrim-chat"})
    public static final class PropertyName
    extends Enum<PropertyName> {
        @NotNull
        private final String jsonName;
        public static final /* enum */ PropertyName NAME = new PropertyName("name");
        public static final /* enum */ PropertyName PATTERN = new PropertyName("pattern");
        public static final /* enum */ PropertyName ENABLED = new PropertyName("enabled");
        private static final /* synthetic */ PropertyName[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PropertyName(String jsonName) {
            this.jsonName = jsonName;
        }

        @NotNull
        public final String getJsonName() {
            return this.jsonName;
        }

        public static PropertyName[] values() {
            return (PropertyName[])$VALUES.clone();
        }

        public static PropertyName valueOf(String value) {
            return Enum.valueOf(PropertyName.class, value);
        }

        @NotNull
        public static EnumEntries<PropertyName> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyNameArray = new PropertyName[]{PropertyName.NAME, PropertyName.PATTERN, PropertyName.ENABLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

