/*
 * Decompiled with CFR 0.152.
 */
package com.skaggsm.mumblelinkmod.client;

import com.skaggsm.jmumblelink.MumbleLink;
import com.skaggsm.jmumblelink.MumbleLinkImpl;
import com.skaggsm.mumblelinkmod.client.ClientConfig;
import com.skaggsm.mumblelinkmod.client.Identity;
import com.skaggsm.mumblelinkmod.client.UtilsKt;
import com.skaggsm.mumblelinkmod.main.MainMumbleLinkMod;
import com.skaggsm.mumblelinkmod.main.SendMumbleURL;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigBranchImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.Platform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\u00020\u00118\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u00020\u00188\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u00020\u00188\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u001a\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u0018\u0010\"\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/skaggsm/mumblelinkmod/client/ClientMumbleLinkMod;", "Lnet/fabricmc/api/ClientModInitializer;", "<init>", "()V", "", "onInitializeClient", "setupConfig", "serialize", "deserialize", "setupEvents", "Lcom/skaggsm/jmumblelink/MumbleLink;", "ensureLinked", "()Lcom/skaggsm/jmumblelink/MumbleLink;", "ensureClosed", "Ljava/nio/file/Path;", "configFile", "Ljava/nio/file/Path;", "Lcom/skaggsm/mumblelinkmod/client/ClientConfig;", "config", "Lcom/skaggsm/mumblelinkmod/client/ClientConfig;", "getConfig", "()Lcom/skaggsm/mumblelinkmod/client/ClientConfig;", "setConfig", "(Lcom/skaggsm/mumblelinkmod/client/ClientConfig;)V", "Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;", "configTree", "Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;", "getConfigTree", "()Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;", "setConfigTree", "(Lio/github/fablabsmc/fablabs/api/fiber/v1/tree/ConfigBranch;)V", "unionConfigTree", "getUnionConfigTree", "setUnionConfigTree", "mumble", "Lcom/skaggsm/jmumblelink/MumbleLink;", "fabric-1.21.11-mumblelink-mod"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nClientMumbleLinkMod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientMumbleLinkMod.kt\ncom/skaggsm/mumblelinkmod/client/ClientMumbleLinkMod\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,181:1\n205#2:182\n*S KotlinDebug\n*F\n+ 1 ClientMumbleLinkMod.kt\ncom/skaggsm/mumblelinkmod/client/ClientMumbleLinkMod\n*L\n133#1:182\n*E\n"})
public final class ClientMumbleLinkMod
implements ClientModInitializer {
    @NotNull
    public static final ClientMumbleLinkMod INSTANCE = new ClientMumbleLinkMod();
    @NotNull
    private static final Path configFile;
    public static ClientConfig config;
    public static ConfigBranch configTree;
    public static ConfigBranch unionConfigTree;
    @Nullable
    private static MumbleLink mumble;

    private ClientMumbleLinkMod() {
    }

    @NotNull
    public final ClientConfig getConfig() {
        ClientConfig clientConfig = config;
        if (clientConfig != null) {
            return clientConfig;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull ClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"<set-?>");
        config = clientConfig;
    }

    @NotNull
    public final ConfigBranch getConfigTree() {
        ConfigBranch configBranch = configTree;
        if (configBranch != null) {
            return configBranch;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configTree");
        return null;
    }

    public final void setConfigTree(@NotNull ConfigBranch configBranch) {
        Intrinsics.checkNotNullParameter((Object)configBranch, (String)"<set-?>");
        configTree = configBranch;
    }

    @NotNull
    public final ConfigBranch getUnionConfigTree() {
        ConfigBranch configBranch = unionConfigTree;
        if (configBranch != null) {
            return configBranch;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"unionConfigTree");
        return null;
    }

    public final void setUnionConfigTree(@NotNull ConfigBranch configBranch) {
        Intrinsics.checkNotNullParameter((Object)configBranch, (String)"<set-?>");
        unionConfigTree = configBranch;
    }

    public void onInitializeClient() {
        this.setupConfig();
        this.setupEvents();
    }

    private final void setupConfig() {
        this.setConfig(new ClientConfig());
        ConfigBranch configBranch = ConfigTree.builder().applyFromPojo((Object)this.getConfig(), MainMumbleLinkMod.INSTANCE.createSettings()).withName("client").build();
        Intrinsics.checkNotNullExpressionValue((Object)configBranch, (String)"build(...)");
        this.setConfigTree(configBranch);
        this.setUnionConfigTree((ConfigBranch)new ConfigBranchImpl("union", null));
        this.getUnionConfigTree().getItems().add((ConfigNode)this.getConfigTree());
        this.getUnionConfigTree().getItems().add((ConfigNode)MainMumbleLinkMod.INSTANCE.getConfigTree());
        if (Files.notExists(configFile, new LinkOption[0])) {
            this.serialize();
        }
        this.deserialize();
    }

    public final void serialize() {
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        FiberSerialization.serialize((ConfigTree)((ConfigTree)this.getConfigTree()), (OutputStream)Files.newOutputStream(configFile, openOptionArray), (ValueSerializer)((ValueSerializer)MainMumbleLinkMod.INSTANCE.getSERIALIZER()));
    }

    private final void deserialize() {
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.READ};
        FiberSerialization.deserialize((ConfigTree)((ConfigTree)this.getConfigTree()), (InputStream)Files.newInputStream(configFile, openOptionArray), (ValueSerializer)((ValueSerializer)MainMumbleLinkMod.INSTANCE.getSERIALIZER()));
    }

    private final void setupEvents() {
        PayloadTypeRegistry.playC2S().register(SendMumbleURL.Companion.getPACKET_ID(), SendMumbleURL.Companion.getPACKET_CODEC());
        PayloadTypeRegistry.playS2C().register(SendMumbleURL.Companion.getPACKET_ID(), SendMumbleURL.Companion.getPACKET_CODEC());
        ClientPlayNetworking.registerGlobalReceiver(SendMumbleURL.Companion.getPACKET_ID(), (ClientPlayNetworking.PlayPayloadHandler)SendMumbleURL.Companion);
        ClientTickEvents.START_CLIENT_TICK.register(ClientMumbleLinkMod::setupEvents$lambda$0);
    }

    private final MumbleLink ensureLinked() {
        MumbleLink localMumble = mumble;
        if (localMumble != null) {
            return localMumble;
        }
        MainMumbleLinkMod.INSTANCE.getLOG().info("Linking to VoIP client...");
        mumble = localMumble = (MumbleLink)new MumbleLinkImpl();
        MainMumbleLinkMod.INSTANCE.getLOG().info("Linked");
        return localMumble;
    }

    private final void ensureClosed() {
        if (mumble != null) {
            MainMumbleLinkMod.INSTANCE.getLOG().info("Unlinking from VoIP client...");
            MumbleLink mumbleLink = mumble;
            if (mumbleLink != null) {
                mumbleLink.close();
            }
            mumble = null;
            MainMumbleLinkMod.INSTANCE.getLOG().info("Unlinked");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void setupEvents$lambda$0(class_310 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_638 world = it.field_1687;
        class_746 player = it.field_1724;
        if (world != null && player != null) {
            void this_$iv;
            MumbleLink mumble = INSTANCE.ensureLinked();
            class_243 position = player.method_5836(1.0f);
            class_243 lookDirection = player.method_5663();
            class_243 topDirection = player.method_18864(1.0f);
            Intrinsics.checkNotNull((Object)position);
            float[] camPos = UtilsKt.getToRHArray(position);
            Intrinsics.checkNotNull((Object)lookDirection);
            float[] camFro = UtilsKt.getToRHArray(lookDirection);
            Intrinsics.checkNotNull((Object)topDirection);
            float[] camTop = UtilsKt.getToRHArray(topDirection);
            float f = camPos[2];
            class_2960 class_29602 = world.method_27983().method_29177();
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"getValue(...)");
            camPos[2] = f + (float)(UtilsKt.getStableHash(class_29602) % 2048) * INSTANCE.getConfig().getClientDimensionYAxisAdjust();
            mumble.setUiVersion(2);
            int n = mumble.getUiTick();
            mumble.setUiTick(n + 1);
            mumble.setAvatarPosition(camPos);
            mumble.setAvatarFront(camFro);
            mumble.setAvatarTop(camTop);
            mumble.setName("Minecraft");
            mumble.setCameraPosition(camPos);
            mumble.setCameraFront(camFro);
            mumble.setCameraTop(camTop);
            Json json = (Json)Json.Default;
            Identity value$iv = new Identity(world, player);
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            mumble.setIdentity(this_$iv.encodeToString((SerializationStrategy)Identity.Companion.serializer(), (Object)value$iv));
            mumble.setContext("{\"domain\":\"AllTalk\"}");
            mumble.setDescription("A Minecraft mod that provides position data to VoIP clients.");
        } else {
            INSTANCE.ensureClosed();
        }
    }

    static {
        Path path = MainMumbleLinkMod.INSTANCE.getConfigFolder().resolve("fabric-mumblelink-mod-client.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        configFile = path;
        if (Platform.get() == Platform.MACOSX) {
            MainMumbleLinkMod.INSTANCE.getLOG().warn("macOS needs java.awt.headless=true right now, so we'll set it later with a reflection hack!");
        } else {
            System.setProperty("java.awt.headless", "false");
        }
    }
}

