/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.client.property;

import com.euphony.enc_vanilla.common.item.SculkCompassItem;
import com.euphony.enc_vanilla.utils.CompassState;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SculkCompassAngleState
extends NeedleDirectionHelper {
    public static final MapCodec<SculkCompassAngleState> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("wobble", (Object)true).forGetter(NeedleDirectionHelper::wobble)).apply((Applicative)instance, SculkCompassAngleState::new));
    private final NeedleDirectionHelper.Wobbler wobbler = this.newWobbler(0.8f);
    private final NeedleDirectionHelper.Wobbler noTargetWobbler = this.newWobbler(0.8f);
    private final RandomSource random = RandomSource.create();

    public SculkCompassAngleState(boolean bl) {
        super(bl);
    }

    protected float calculate(ItemStack itemStack, ClientLevel clientLevel, int i, Entity entity) {
        SculkCompassItem compassTarget = (SculkCompassItem)itemStack.getItem();
        BlockPos blockPos = new BlockPos(compassTarget.getFoundBiomeX(itemStack), 0, compassTarget.getFoundBiomeZ(itemStack));
        long gameTime = clientLevel.getGameTime();
        return compassTarget.getState(itemStack) == CompassState.FOUND ? this.getRotationTowardsCompassTarget(entity, gameTime, blockPos) : this.getRandomlySpinningRotation(i, gameTime);
    }

    private float getRandomlySpinningRotation(int i, long l) {
        if (this.noTargetWobbler.shouldUpdate(l)) {
            this.noTargetWobbler.update(l, this.random.nextFloat());
        }
        float f = this.noTargetWobbler.rotation() + (float)SculkCompassAngleState.hash(i) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity entity, long l, BlockPos blockPos) {
        Player player;
        float f = (float)SculkCompassAngleState.getAngleFromEntityToPos(entity, blockPos);
        float g = SculkCompassAngleState.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(l)) {
                this.wobbler.update(l, 0.5f - (g - 0.25f));
            }
            float h = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)h, (float)1.0f);
        }
        float h = 0.5f - (g - 0.25f - f);
        return Mth.positiveModulo((float)h, (float)1.0f);
    }

    private static double getAngleFromEntityToPos(Entity entity, BlockPos blockPos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int i) {
        return i * 1327217883;
    }
}

