/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.block;

import com.euphony.enc_vanilla.common.entity.block.AppraisalTableBlockEntity;
import com.euphony.enc_vanilla.common.init.EVBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class AppraisalTableBlock
extends BaseEntityBlock {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.appraisal");
    public static final MapCodec<AppraisalTableBlock> CODEC = AppraisalTableBlock.simpleCodec(AppraisalTableBlock::new);

    public AppraisalTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return AppraisalTableBlock.createAppraisalTicker(level, blockEntityType, (BlockEntityType<? extends AppraisalTableBlockEntity>)((BlockEntityType)EVBlockEntities.APPRAISAL.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createAppraisalTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends AppraisalTableBlockEntity> blockEntityType2) {
        return level.isClientSide ? null : AppraisalTableBlock.createTickerHelper(blockEntityType, blockEntityType2, AppraisalTableBlockEntity::serverTick);
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof AppraisalTableBlockEntity) {
            player.openMenu((MenuProvider)blockEntity);
        }
    }

    protected InteractionResult useWithoutItem(BlockState arg, Level arg2, BlockPos arg3, Player arg4, BlockHitResult arg5) {
        if (arg2.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openContainer(arg2, arg3, arg4);
        return InteractionResult.CONSUME;
    }

    public void drop(Level level, BlockPos arg3, AppraisalTableBlockEntity blockEntity, int index) {
        Containers.dropItemStack((Level)level, (double)arg3.getX(), (double)arg3.getY(), (double)arg3.getZ(), (ItemStack)blockEntity.getItem(index));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new AppraisalTableBlockEntity(blockPos, blockState);
    }
}

