/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CeilingTorchBlock
extends TorchBlock {
    public static final VoxelShape CEILING_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final Block originalBlock;

    public CeilingTorchBlock(BlockBehaviour.Properties properties, SimpleParticleType particle, Block originalBlock) {
        super(particle, properties);
        this.originalBlock = originalBlock;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CEILING_SHAPE;
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos facingPos, BlockState blockState2, RandomSource randomSource) {
        return direction == Direction.UP && !this.canSurvive(blockState, levelReader, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, levelReader, scheduledTickAccess, currentPos, direction, facingPos, blockState2, randomSource);
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        return List.of(new ItemStack((ItemLike)this.originalBlock));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CeilingTorchBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    protected ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return new ItemStack((ItemLike)this.originalBlock);
    }
}

