/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterloggedLilyPadBlock
extends WaterlilyBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape AABB_SUPPORT = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public WaterloggedLilyPadBlock(BlockBehaviour.Properties properties) {
        super(properties.overrideDescription(Blocks.LILY_PAD.getDescriptionId()));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        return AABB;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @NotNull
    public VoxelShape getBlockSupportShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return AABB_SUPPORT;
    }

    @NotNull
    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return Fluids.WATER.getSource(false);
    }

    public long getSeed(BlockState pState, BlockPos pPos) {
        return Mth.getSeed((Vec3i)pPos.above());
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos facingPos, BlockState blockState2, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return blockState;
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (this.tryConvertToVanilla((LevelAccessor)serverLevel, pos)) {
            super.tick(state, serverLevel, pos, random);
        }
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, @Nullable Orientation orientation, boolean bl) {
        super.neighborChanged(blockState, level, blockPos, block, orientation, bl);
        if (level.getBlockState(blockPos.above()).isAir()) {
            this.tryConvertToVanilla((LevelAccessor)level, blockPos);
        }
    }

    private boolean tryConvertToVanilla(LevelAccessor serverLevel, BlockPos pos) {
        Block block;
        if (serverLevel.getBlockState(pos.above()).isAir() && (block = serverLevel.getBlockState(pos).getBlock()) instanceof WaterloggedLilyPadBlock) {
            WaterloggedLilyPadBlock block2 = (WaterloggedLilyPadBlock)block;
            serverLevel.setBlock(pos, Blocks.WATER.defaultBlockState(), 3);
            serverLevel.setBlock(pos.above(), Blocks.LILY_PAD.withPropertiesOf(block2.defaultBlockState()), 3);
            return true;
        }
        return false;
    }

    @NotNull
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List drops = super.getDrops(state, params);
        drops.add(Items.LILY_PAD.getDefaultInstance());
        return drops;
    }

    public boolean canPlaceLiquid(@Nullable LivingEntity livingEntity, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

