/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.entity.block;

import com.euphony.enc_vanilla.common.init.EVBlockEntities;
import com.euphony.enc_vanilla.common.init.EVDataComponentTypes;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.screen.AppraisalTableMenu;
import com.euphony.enc_vanilla.utils.WeightedRandomSampler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;

public class AppraisalTableBlockEntity
extends BaseContainerBlockEntity {
    protected final ContainerData dataAccess;
    int progress = 0;
    boolean isActive = false;
    boolean isError = false;
    WeightedRandomSampler<Holder<Biome>> weightedRandomSampler;
    ItemStack originalStack = ItemStack.EMPTY;
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);

    public AppraisalTableBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EVBlockEntities.APPRAISAL.get(), blockPos, blockState);
        this.weightedRandomSampler = new WeightedRandomSampler();
        this.dataAccess = new ContainerData(){

            public int get(int i) {
                switch (i) {
                    case 0: {
                        return AppraisalTableBlockEntity.this.progress;
                    }
                    case 1: {
                        return AppraisalTableBlockEntity.this.isActive ? 1 : 0;
                    }
                    case 2: {
                        return AppraisalTableBlockEntity.this.isError ? 1 : 0;
                    }
                }
                return 0;
            }

            public void set(int i, int j) {
                switch (i) {
                    case 0: {
                        AppraisalTableBlockEntity.this.progress = j;
                        break;
                    }
                    case 1: {
                        AppraisalTableBlockEntity.this.isActive = j != 0;
                        break;
                    }
                    case 2: {
                        AppraisalTableBlockEntity.this.isError = j != 0;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.appraisal");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.items = nonNullList;
    }

    public void setItem(int i, ItemStack arg) {
        ItemStack itemstack = (ItemStack)this.items.get(i);
        boolean flag = !arg.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)arg);
        this.items.set(i, (Object)arg);
        arg.limitSize(this.getMaxStackSize(arg));
        if (i == 0 && !flag) {
            this.progress = 0;
            this.setChanged();
        }
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return new AppraisalTableMenu(i, inventory, (Container)this, this.dataAccess);
    }

    public int getContainerSize() {
        return this.items.size();
    }

    protected void saveAdditional(ValueOutput compoundTag) {
        super.saveAdditional(compoundTag);
        compoundTag.putInt("Progress", this.progress);
        compoundTag.putBoolean("IsActive", this.isActive);
        compoundTag.putBoolean("IsError", this.isError);
        ContainerHelper.saveAllItems((ValueOutput)compoundTag, this.items);
    }

    protected void loadAdditional(ValueInput compoundTag) {
        super.loadAdditional(compoundTag);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)compoundTag, this.items);
        this.progress = (Integer)compoundTag.getInt("Progress").get();
        this.isActive = compoundTag.getBooleanOr("IsActive", false);
        this.isError = compoundTag.getBooleanOr("IsError", false);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, AppraisalTableBlockEntity arg4) {
        ItemStack originalInput = arg4.getItem(0);
        if (!originalInput.isEmpty()) {
            if (((ItemStack)arg4.items.get(2)).isEmpty()) {
                if (arg4.dataAccess.get(0) < 80) {
                    boolean isLocked = (Boolean)originalInput.getOrDefault((DataComponentType)EVDataComponentTypes.LOCKED.get(), (Object)false);
                    boolean isTempUnlocked = (Boolean)originalInput.getOrDefault((DataComponentType)EVDataComponentTypes.TEMP_UNLOCKED.get(), (Object)false);
                    if (!isLocked || isTempUnlocked) {
                        ++arg4.progress;
                    }
                } else {
                    ItemStack input = originalInput.copy();
                    if (!arg4.originalStack.is(input.getItem())) {
                        List<Holder> biomes;
                        float max;
                        float min;
                        if (input.is((Item)EVItems.BIOME_CRYSTAL_ITEM.get())) {
                            min = 0.0f;
                            max = 1.0f;
                        } else if (input.is(EVItems.FROZEN_BIOME_CRYSTAL_ITEM)) {
                            min = -1.0f;
                            max = 0.0f;
                        } else {
                            min = 1.0f;
                            max = 2.0f;
                        }
                        Registry biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
                        ResourceLocation levelDimension = level.dimension().location();
                        if (levelDimension.getNamespace().equals("minecraft")) {
                            TagKey biomeTagKey = levelDimension.equals((Object)BuiltinDimensionTypes.OVERWORLD.location()) ? BiomeTags.IS_OVERWORLD : (levelDimension.equals((Object)BuiltinDimensionTypes.NETHER.location()) ? BiomeTags.IS_NETHER : BiomeTags.IS_END);
                            biomes = biomeRegistry.stream().map(arg_0 -> ((Registry)biomeRegistry).wrapAsHolder(arg_0)).filter(biomeHolder -> biomeHolder.is(biomeTagKey)).filter(biomeHolder -> AppraisalTableBlockEntity.biomeTemperatureInRange(((Biome)biomeHolder.value()).getBaseTemperature(), min, max)).toList();
                        } else {
                            ResourceKey dimensionKey = level.dimension();
                            Registry dimensionRegistry = level.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
                            ResourceKey stemKey = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)dimensionKey.location());
                            biomes = biomeRegistry.stream().map(arg_0 -> ((Registry)biomeRegistry).wrapAsHolder(arg_0)).filter(holder -> AppraisalTableBlockEntity.biomeTemperatureInRange(((Biome)holder.value()).getBaseTemperature(), min, max)).toList();
                        }
                        arg4.originalStack = input;
                        arg4.weightedRandomSampler.init(biomes);
                    }
                    Holder<Biome> biome = arg4.weightedRandomSampler.sample();
                    if (!((Boolean)input.getOrDefault((DataComponentType)EVDataComponentTypes.LOCKED.get(), (Object)false)).booleanValue()) {
                        input.set((DataComponentType)EVDataComponentTypes.LOCKED.get(), (Object)true);
                    }
                    input.set((DataComponentType)EVDataComponentTypes.TEMP_UNLOCKED.get(), (Object)false);
                    arg4.setItem(0, input);
                    if (biome == null) {
                        arg4.isError = true;
                    } else {
                        ItemStack input1 = input.copy();
                        input1.set((DataComponentType)EVDataComponentTypes.BIOME.get(), (Object)((ResourceKey)biome.unwrapKey().get()));
                        arg4.setItem(2, input1);
                    }
                    arg4.progress = 0;
                }
            }
        } else {
            arg4.progress = 0;
            arg4.items.set(2, (Object)ItemStack.EMPTY);
        }
        if ((!((ItemStack)arg4.items.get(1)).isEmpty() && (!arg4.getItem(2).isEmpty() || arg4.getItem(0).has((DataComponentType)EVDataComponentTypes.LOCKED.get()))) != arg4.isActive) {
            arg4.isActive = !arg4.isActive;
        }
    }

    public static boolean biomeTemperatureInRange(float value, float min, float max) {
        return (value = Mth.clamp((float)value, (float)-1.0f, (float)2.0f)) - min >= -1.0E-5f && max - value >= -1.0E-5f;
    }
}

