/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.init;

import com.euphony.enc_vanilla.common.block.AppraisalTableBlock;
import com.euphony.enc_vanilla.common.block.CeilingTorchBlock;
import com.euphony.enc_vanilla.common.block.CutBambooSaplingBlock;
import com.euphony.enc_vanilla.common.block.CutSugarCaneBlock;
import com.euphony.enc_vanilla.common.block.CutVineBlock;
import com.euphony.enc_vanilla.common.block.RedstoneCeilingTorchBlock;
import com.euphony.enc_vanilla.common.block.WaterloggedLilyPadBlock;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.utils.Utils;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class EVBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"enc_vanilla", (ResourceKey)Registries.BLOCK);
    public static final RegistrySupplier<WaterloggedLilyPadBlock> WATERLOGGED_LILY_PAD = EVBlocks.registerWithItem("waterlogged_lily_pad", WaterloggedLilyPadBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LILY_PAD));
    public static final RegistrySupplier<CutVineBlock> CUT_VINE = EVBlocks.registerWithItem("cut_vine", CutVineBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE));
    public static final RegistrySupplier<CutSugarCaneBlock> CUT_SUGAR_CANE = EVBlocks.registerWithItem("cut_sugar_cane", CutSugarCaneBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SUGAR_CANE));
    public static final RegistrySupplier<CutBambooSaplingBlock> CUT_BAMBOO_SAPLING = EVBlocks.registerWithItem("cut_bamboo_sapling", CutBambooSaplingBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BAMBOO_SAPLING).instabreak());
    public static final RegistrySupplier<CeilingTorchBlock> CEILING_TORCH = EVBlocks.registerWithItem("torch", p -> new CeilingTorchBlock((BlockBehaviour.Properties)p, ParticleTypes.FLAME, Blocks.TORCH), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH));
    public static final RegistrySupplier<RedstoneCeilingTorchBlock> CEILING_REDSTONE_TORCH = EVBlocks.registerWithItem("redstone_torch", p -> new RedstoneCeilingTorchBlock((BlockBehaviour.Properties)p, Blocks.REDSTONE_TORCH), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.REDSTONE_TORCH));
    public static final RegistrySupplier<CeilingTorchBlock> CEILING_SOUL_TORCH = EVBlocks.registerWithItem("soul_torch", p -> new CeilingTorchBlock((BlockBehaviour.Properties)p, ParticleTypes.SOUL_FIRE_FLAME, Blocks.SOUL_TORCH), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_TORCH));
    public static final RegistrySupplier<AppraisalTableBlock> APPRAISAL_TABLE = EVBlocks.registerWithItem("appraisal_table", AppraisalTableBlock::new, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE));

    public static <T extends Block> RegistrySupplier<T> register(String name, Supplier<? extends T> supplier) {
        return BLOCKS.register(name, supplier);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<? extends T> supplier) {
        RegistrySupplier<? extends T> ret = EVBlocks.register(name, supplier);
        EVItems.registerBlockItem(name, ret);
        return ret;
    }

    public static <T extends Block> RegistrySupplier<T> register(String name, Function<BlockBehaviour.Properties, T> func, BlockBehaviour.Properties properties) {
        return BLOCKS.register(name, () -> (Block)func.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Utils.prefix(name)))));
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Function<BlockBehaviour.Properties, T> func, BlockBehaviour.Properties properties) {
        RegistrySupplier<T> ret = EVBlocks.register(name, func, properties);
        EVItems.registerBlockItem(name, ret);
        return ret;
    }

    public static RegistrySupplier<Block> register(String name, Block block) {
        return EVBlocks.register(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block)));
    }

    public static RegistrySupplier<Block> registerWithItem(String name, Block block) {
        RegistrySupplier ret = BLOCKS.register(name, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block)));
        EVItems.registerBlockItem(name, (RegistrySupplier<? extends Block>)ret);
        return ret;
    }
}

