/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.item;

import com.euphony.enc_vanilla.common.init.EVDataComponentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrogBucketItem
extends MobBucketItem {
    public FrogBucketItem(Item.Properties properties) {
        super(EntityType.FROG, (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, properties.component((DataComponentType)EVDataComponentTypes.ACTIVE.get(), (Object)false));
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull ServerLevel level, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        Vec3 pos = entity.position();
        int x = Mth.floor((double)pos.x);
        int z = Mth.floor((double)pos.z);
        boolean isActive = (Boolean)stack.get((DataComponentType)EVDataComponentTypes.ACTIVE.get());
        if (isActive != FrogBucketItem.isSlimeChunk(level, x, z)) {
            stack.set((DataComponentType)EVDataComponentTypes.ACTIVE.get(), (Object)(!isActive ? 1 : 0));
        }
    }

    public static boolean isSlimeChunk(ServerLevel world, int x, int z) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(x, 0, z));
        return WorldgenRandom.seedSlimeChunk((int)chunkpos.x, (int)chunkpos.z, (long)world.getSeed(), (long)987234911L).nextInt(10) == 0;
    }
}

