/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.item;

import com.euphony.enc_vanilla.common.init.EVDataComponentTypes;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.common.tag.EVItemTags;
import com.euphony.enc_vanilla.config.categories.tools.ToolsConfig;
import com.euphony.enc_vanilla.utils.CompassState;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SculkCompassItem
extends Item {
    public static final int USE_DURATION = 40;

    public SculkCompassItem(Item.Properties properties) {
        super(properties.stacksTo(1).component((DataComponentType)EVDataComponentTypes.COMPASS_STATE.get(), (Object)CompassState.INACTIVE.getID()));
    }

    @NotNull
    public InteractionResult use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack offhandItem;
        CompassState state;
        if (!((ToolsConfig)ToolsConfig.HANDLER.instance()).enableSculkCompass) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide() && hand == InteractionHand.MAIN_HAND && player.getMainHandItem().is((Item)EVItems.SCULK_COMPASS_ITEM.get()) && (state = this.getState(player.getItemInHand(hand))) == CompassState.INACTIVE && (offhandItem = player.getOffhandItem()).is(EVItemTags.BIOME_CRYSTAL) && offhandItem.get((DataComponentType)EVDataComponentTypes.BIOME.get()) != null) {
            player.startUsingItem(hand);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!level.isClientSide()) {
                if (Math.random() < (double)0.01f) {
                    level.explode((Entity)player, Explosion.getDefaultDamageSource((Level)level, (Entity)player), null, player.getX(), player.getY(), player.getZ(), 3.0f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.SONIC_BOOM, (ParticleOptions)ParticleTypes.SONIC_BOOM, Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)SoundEvents.WARDEN_SONIC_BOOM.location())));
                    player.hurt(player.damageSources().sonicBoom((Entity)player), 10.0f);
                    player.getOffhandItem().consume(1, (LivingEntity)player);
                    stack = new ItemStack((ItemLike)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get());
                } else {
                    ResourceKey biomeResourceKey = (ResourceKey)player.getOffhandItem().get((DataComponentType)EVDataComponentTypes.BIOME.get());
                    SculkCompassItem.locateBiome((ServerLevel)level, player.getEyePosition(), biome -> biome.is(biomeResourceKey), stack);
                }
            }
        }
        return stack;
    }

    private static void locateBiome(ServerLevel level, Vec3 pos, Predicate<Holder<Biome>> biome, ItemStack stack) {
        BlockPos blockpos = BlockPos.containing((Position)pos);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        Pair pair = level.findClosestBiome3d(biome, blockpos, 6400, 32, 64);
        stopwatch.stop();
        if (pair == null) {
            SculkCompassItem.setState(stack, CompassState.NOT_FOUND);
        } else {
            SculkCompassItem.setFoundBiomeX(stack, ((BlockPos)pair.getFirst()).getX());
            SculkCompassItem.setFoundBiomeZ(stack, ((BlockPos)pair.getFirst()).getZ());
            SculkCompassItem.setState(stack, CompassState.FOUND);
        }
    }

    public static void setState(ItemStack stack, CompassState state) {
        if (stack.is((Item)EVItems.SCULK_COMPASS_ITEM.get())) {
            stack.set((DataComponentType)EVDataComponentTypes.COMPASS_STATE.get(), (Object)state.getID());
        }
    }

    public static void setFoundBiomeX(ItemStack stack, int x) {
        stack.set((DataComponentType)EVDataComponentTypes.FOUND_X.get(), (Object)x);
    }

    public static void setFoundBiomeZ(ItemStack stack, int z) {
        stack.set((DataComponentType)EVDataComponentTypes.FOUND_Z.get(), (Object)z);
    }

    public CompassState getState(ItemStack stack) {
        return CompassState.fromID((Integer)stack.get((DataComponentType)EVDataComponentTypes.COMPASS_STATE.get()));
    }

    public int getFoundBiomeX(ItemStack stack) {
        if (stack.is((Item)EVItems.SCULK_COMPASS_ITEM.get()) && stack.has((DataComponentType)EVDataComponentTypes.FOUND_X.get())) {
            return (Integer)stack.get((DataComponentType)EVDataComponentTypes.FOUND_X.get());
        }
        return 0;
    }

    public int getFoundBiomeZ(ItemStack stack) {
        if (stack.is((Item)EVItems.SCULK_COMPASS_ITEM.get()) && stack.has((DataComponentType)EVDataComponentTypes.FOUND_X.get())) {
            return (Integer)stack.get((DataComponentType)EVDataComponentTypes.FOUND_Z.get());
        }
        return 0;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 40;
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.BOW;
    }
}

