/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class CeilingTorchEvent {
    private static final Map<Item, Block> placeEntries = ImmutableMap.of((Object)Items.TORCH, (Object)((Block)EVBlocks.CEILING_TORCH.get()), (Object)Items.REDSTONE_TORCH, (Object)((Block)EVBlocks.CEILING_REDSTONE_TORCH.get()), (Object)Items.SOUL_TORCH, (Object)((Block)EVBlocks.CEILING_SOUL_TORCH.get()));

    public static InteractionResult rightClickBlock(Player player, InteractionHand interactionHand, BlockPos blockPos, Direction direction) {
        Level level = player.level();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        if (!player.isSpectator()) {
            ItemStack stack;
            BlockPos placeAt = blockPos.relative(direction);
            if (direction == Direction.DOWN && (level.isEmptyBlock(placeAt) || !level.getFluidState(placeAt).isEmpty()) && placeEntries.containsKey((stack = player.getItemInHand(interactionHand)).getItem())) {
                CeilingTorchEvent.placeTorch(player, interactionHand, stack, placeAt, level, placeEntries.get(stack.getItem()).defaultBlockState());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void placeTorch(Player player, InteractionHand hand, ItemStack stack, BlockPos pos, Level level, BlockState state) {
        if (state.canSurvive((LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, state);
            SoundType soundType = state.getBlock().defaultBlockState().getSoundType();
            level.playSound((Entity)player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
            player.swing(hand);
            stack.consume(1, (LivingEntity)player);
        }
    }
}

