/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;

public class DoubleDoorEvent {
    public static InteractionResult rightClickBlock(Player player, InteractionHand interactionHand, BlockPos blockPos, Direction direction) {
        DoorBlock block;
        Level level = player.level();
        if (level.isClientSide || !((QolConfig)QolConfig.HANDLER.instance()).enableDoubleDoor) {
            return InteractionResult.PASS;
        }
        if (interactionHand != InteractionHand.MAIN_HAND || player.isCrouching()) {
            return InteractionResult.PASS;
        }
        BlockState blockState = level.getBlockState(blockPos);
        Block block2 = blockState.getBlock();
        if (block2 instanceof DoorBlock && (block = (DoorBlock)block2).type().canOpenByHand()) {
            boolean isOpen = (Boolean)blockState.getValue((Property)DoorBlock.OPEN);
            DoorHingeSide side = (DoorHingeSide)blockState.getValue((Property)DoorBlock.HINGE);
            Direction doorDirection = (Direction)blockState.getValue((Property)DoorBlock.FACING);
            BlockPos relativeBlockPos = side == DoorHingeSide.LEFT ? blockPos.relative(doorDirection.getClockWise()) : blockPos.relative(doorDirection.getCounterClockWise());
            BlockState relativeBlockState = level.getBlockState(relativeBlockPos);
            if (relativeBlockState.getBlock() instanceof DoorBlock && (Boolean)relativeBlockState.getValue((Property)DoorBlock.OPEN) == isOpen) {
                level.setBlock(relativeBlockPos, (BlockState)relativeBlockState.cycle((Property)DoorBlock.OPEN), 10);
            }
            level.setBlock(blockPos, (BlockState)blockState.cycle((Property)DoorBlock.OPEN), 10);
            level.playSound((Entity)player, blockPos, (Boolean)blockState.getValue((Property)DoorBlock.OPEN) != false ? block.type().doorOpen() : block.type().doorClose(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

