/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.utils.BlockEntityMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HealingCampfireEvent {
    public static void playerPost(Player player) {
        Level level = player.level();
        if (level.isClientSide || !((QolConfig)QolConfig.HANDLER.instance()).enableHealingCampfire) {
            return;
        }
        if (player.tickCount % ((QolConfig)QolConfig.HANDLER.instance()).checkEveryTick != 0) {
            return;
        }
        if (!BlockEntityMap.cachedBlockEntities.get(BlockEntityType.CAMPFIRE).containsKey(level)) {
            return;
        }
        BlockPos entityPos = player.blockPosition();
        Vec3i entityVec3i = new Vec3i(entityPos.getX(), entityPos.getY(), entityPos.getZ());
        BlockPos pos = null;
        int radius = ((QolConfig)QolConfig.HANDLER.instance()).healingRadius;
        for (BlockEntity campfireBlockEntity : BlockEntityMap.cachedBlockEntities.get(BlockEntityType.CAMPFIRE).get(level)) {
            Boolean isLit;
            BlockState campfireState;
            BlockPos campfirePos = campfireBlockEntity.getBlockPos();
            if (!campfirePos.closerThan(entityVec3i, (double)radius) || (campfireState = campfireBlockEntity.getBlockState()).is(Blocks.SOUL_CAMPFIRE) || !(isLit = (Boolean)campfireState.getValue((Property)CampfireBlock.LIT)).booleanValue()) continue;
            pos = campfirePos;
            break;
        }
        if (pos == null) {
            return;
        }
        MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.REGENERATION, (int)(((QolConfig)QolConfig.HANDLER.instance()).effectDuration * 20.0), ((QolConfig)QolConfig.HANDLER.instance()).effectLevel - 1);
        BlockPos playerPos = player.blockPosition();
        if (playerPos.closerThan(pos, (double)radius)) {
            MobEffectInstance effect = player.getEffect(MobEffects.REGENERATION);
            if (effect != null) {
                int duration = effect.getDuration();
                if ((double)duration < ((QolConfig)QolConfig.HANDLER.instance()).effectDuration * 10.0) {
                    player.addEffect(effectInstance);
                }
            } else {
                player.addEffect(effectInstance);
            }
        }
    }
}

