/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import dev.architectury.event.EventResult;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractChestBoat;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class PlaceChestOnBoatEvent {
    private static final Map<Item, EntityType<? extends AbstractChestBoat>> ITEM_ENTITY_MAP = Map.of(Items.ACACIA_BOAT, EntityType.ACACIA_CHEST_BOAT, Items.BIRCH_BOAT, EntityType.BIRCH_CHEST_BOAT, Items.DARK_OAK_BOAT, EntityType.DARK_OAK_CHEST_BOAT, Items.CHERRY_BOAT, EntityType.CHERRY_CHEST_BOAT, Items.OAK_BOAT, EntityType.OAK_CHEST_BOAT, Items.JUNGLE_BOAT, EntityType.JUNGLE_CHEST_BOAT, Items.SPRUCE_BOAT, EntityType.SPRUCE_CHEST_BOAT, Items.MANGROVE_BOAT, EntityType.MANGROVE_CHEST_BOAT, Items.PALE_OAK_BOAT, EntityType.PALE_OAK_CHEST_BOAT, Items.BAMBOO_RAFT, EntityType.BAMBOO_CHEST_RAFT);

    public static EventResult interactEntity(Player player, Entity entity, InteractionHand interactionHand) {
        AbstractChestBoat newBoat;
        if (!((QolConfig)QolConfig.HANDLER.instance()).enablePlaceChestOnBoat) {
            return EventResult.pass();
        }
        Level level = player.level();
        if (level.isClientSide) {
            return EventResult.pass();
        }
        BlockPos pos = entity.getOnPos();
        ItemStack stack = player.getItemInHand(interactionHand);
        if (!(entity instanceof Boat)) {
            return EventResult.pass();
        }
        Boat boat = (Boat)entity;
        if (player.isShiftKeyDown() && stack.is(Items.CHEST) && (newBoat = PlaceChestOnBoatEvent.createChestBoatFromBoat(level, boat, player)) != null) {
            boat.discard();
            stack.consume(1, (LivingEntity)player);
            level.addFreshEntity((Entity)newBoat);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static AbstractChestBoat createChestBoatFromBoat(Level level, Boat boat, Player player) {
        Optional<EntityType<? extends AbstractChestBoat>> type = Optional.ofNullable(ITEM_ENTITY_MAP.get(boat.getPickResult()));
        if (type.isEmpty()) {
            return null;
        }
        AbstractChestBoat newBoat = (AbstractChestBoat)type.get().create(level, EntitySpawnReason.SPAWN_ITEM_USE);
        EntityType.createDefaultStackConfig((Level)level, (ItemStack)boat.getPickResult(), (LivingEntity)player).accept(newBoat);
        newBoat.setXRot(boat.getXRot());
        newBoat.setYRot(boat.getYRot());
        newBoat.setPos(boat.position());
        return newBoat;
    }
}

