/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RightClickHarvestEvent {
    public static InteractionResult rightClickBlock(Player player, InteractionHand interactionHand, BlockPos blockPos, Direction direction) {
        Level level = player.level();
        if (level.isClientSide() || !((QolConfig)QolConfig.HANDLER.instance()).enableRightClickHarvest) {
            return InteractionResult.PASS;
        }
        if (player.isSpectator() || player.isCrouching() || interactionHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (((QolConfig)QolConfig.HANDLER.instance()).hungerCost > 0.0 && !player.getAbilities().instabuild && player.getFoodData().getFoodLevel() <= 0) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(interactionHand);
        if (((QolConfig)QolConfig.HANDLER.instance()).requiredHoe && !stack.is(ItemTags.HOES)) {
            return InteractionResult.PASS;
        }
        BlockState state = level.getBlockState(blockPos);
        Block block = state.getBlock();
        if ((block instanceof CocoaBlock || block instanceof CropBlock || block instanceof NetherWartBlock) && RightClickHarvestEvent.isMature(state)) {
            if (!level.isClientSide) {
                player.swing(interactionHand);
                RightClickHarvestEvent.dropStacks(state, (ServerLevel)level, blockPos, (Entity)player, stack);
                level.setBlockAndUpdate(blockPos, RightClickHarvestEvent.getReplantState(state));
                player.causeFoodExhaustion((float)((QolConfig)QolConfig.HANDLER.instance()).hungerCost * 0.005f);
                if (((QolConfig)QolConfig.HANDLER.instance()).enableHarvestXp) {
                    player.giveExperiencePoints(((QolConfig)QolConfig.HANDLER.instance()).xpAmount);
                }
            } else {
                player.playSound(state.getBlock() instanceof NetherWartBlock ? SoundEvents.NETHER_WART_PLANTED : SoundEvents.CROP_PLANTED, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean isMature(BlockState state) {
        if (state.getBlock() instanceof CocoaBlock) {
            return (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2;
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.isMaxAge(state);
        }
        if (state.getBlock() instanceof NetherWartBlock) {
            return (Integer)state.getValue((Property)NetherWartBlock.AGE) >= 3;
        }
        return false;
    }

    private static BlockState getReplantState(BlockState state) {
        if (state.getBlock() instanceof CocoaBlock) {
            return (BlockState)state.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0));
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return (BlockState)state.setValue((Property)cropBlock.getAgeProperty(), (Comparable)Integer.valueOf(0));
        }
        if (state.getBlock() instanceof NetherWartBlock) {
            return (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(BlockState state, ServerLevel level, BlockPos pos, Entity entity, ItemStack itemStack) {
        Item replant = state.getBlock().asItem();
        Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)itemStack).forEach(stack -> {
            if (stack.getItem() == replant) {
                stack.setCount(stack.getCount() - 1);
            }
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
        });
        state.spawnAfterBreak(level, pos, itemStack, true);
    }
}

