/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class SwitchPaintingEvent {
    @NotNull
    private static BlockPos getBlockPos(Painting painting1, Direction dir) {
        AABB bb = painting1.getBoundingBox();
        return switch (dir) {
            case Direction.SOUTH -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.maxZ);
            case Direction.WEST -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.minZ);
            case Direction.EAST -> BlockPos.containing((double)bb.maxX, (double)(bb.maxY - 0.5), (double)(bb.maxZ - 0.5));
            default -> BlockPos.containing((double)(bb.maxX - 0.5), (double)(bb.maxY - 0.5), (double)bb.minZ);
        };
    }

    private static int variantArea(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.value()).area();
    }

    public static EventResult interactEntity(Player player, Entity entity, InteractionHand interactionHand) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enablePaintingSwitching) {
            return EventResult.pass();
        }
        Level level = player.level();
        if (level.isClientSide || interactionHand != InteractionHand.OFF_HAND) {
            return EventResult.pass();
        }
        if (!player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty()) {
            return EventResult.pass();
        }
        if (entity.getType() == EntityType.PAINTING) {
            Painting painting = (Painting)entity;
            ArrayList<Holder> list = new ArrayList<Holder>();
            level.registryAccess().lookupOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(list::add);
            if (!list.isEmpty()) {
                list.removeIf(p_344343_ -> {
                    painting.setVariant(p_344343_);
                    return !painting.survives();
                });
                list.remove(painting.getVariant());
                if (!list.isEmpty()) {
                    int i = list.stream().mapToInt(SwitchPaintingEvent::variantArea).max().orElse(0);
                    list.removeIf(p_218883_ -> SwitchPaintingEvent.variantArea((Holder<PaintingVariant>)p_218883_) < i);
                    Optional optional = Util.getRandomSafe(list, (RandomSource)painting.getRandom());
                    if (optional.isPresent()) {
                        painting.setVariant((Holder)optional.get());
                        player.swing(interactionHand);
                        return EventResult.interruptTrue();
                    }
                }
            }
        }
        return EventResult.pass();
    }
}

