/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.utils.ItemUtils;
import dev.architectury.event.EventResult;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public final class TorchHitEvent {
    public static EventResult livingHurt(LivingEntity livingEntity, DamageSource damageSource, float v) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enableTorchHit) {
            return EventResult.pass();
        }
        Entity entity = damageSource.getEntity();
        if (entity == null || entity.level().isClientSide) {
            return EventResult.pass();
        }
        Entity directEntity = damageSource.getDirectEntity();
        if (entity instanceof LivingEntity) {
            InteractionHand interactionHand;
            LivingEntity attacker = (LivingEntity)entity;
            if (entity.equals((Object)directEntity) && !entity.isSpectator() && TorchHitEvent.canAttack(attacker, livingEntity) && (interactionHand = TorchHitEvent.getInteractionHand(attacker)) != null && !livingEntity.fireImmune()) {
                ItemStack item = attacker.getItemInHand(interactionHand);
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    TorchHitEvent.attack((Entity)livingEntity, item);
                }
            }
        }
        return EventResult.pass();
    }

    private static void attack(Entity target, ItemStack item) {
        double seconds = TorchHitEvent.getFireSeconds(item, target, ((QolConfig)QolConfig.HANDLER.instance()).torchHitFireDuration);
        if (seconds > 0.0) {
            target.igniteForSeconds((float)seconds);
        }
    }

    private static double getFireSeconds(ItemStack item, Entity target, double seconds) {
        if (Math.random() * 100.0 < (double)((QolConfig)QolConfig.HANDLER.instance()).torchHitFireChance) {
            return seconds;
        }
        return 0.0;
    }

    @Nullable
    private static InteractionHand getInteractionHand(LivingEntity attacker) {
        if (TorchHitEvent.isTorch(attacker.getMainHandItem())) {
            return InteractionHand.MAIN_HAND;
        }
        if (TorchHitEvent.isTorch(attacker.getOffhandItem())) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isTorch(ItemStack item) {
        return item.is(Items.TORCH) || ((QolConfig)QolConfig.HANDLER.instance()).extraTorchItems.contains(ItemUtils.getKey(item.getItem()).toString()) || TorchHitEvent.isSoulTorch(item);
    }

    private static boolean isSoulTorch(ItemStack item) {
        return item.is(Items.SOUL_TORCH) || ((QolConfig)QolConfig.HANDLER.instance()).extraSoulTorchItems.contains(ItemUtils.getKey(item.getItem()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof Player)) {
            if (!((QolConfig)QolConfig.HANDLER.instance()).enableMobTorchHit) return false;
        }
        if (!attacker.canAttack(target)) return false;
        if (!(attacker instanceof Player)) return true;
        Player attackerPlayer = (Player)attacker;
        if (!(target instanceof Player)) return true;
        Player targetPlayer = (Player)target;
        if (!attackerPlayer.canHarmPlayer(targetPlayer)) return false;
        return true;
    }
}

