/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.api.IClientSideMerchant;
import com.euphony.enc_vanilla.api.IMerchantMenu;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantMenu.class})
public abstract class MerchantMenuMixin
implements IMerchantMenu {
    @Shadow
    private int merchantLevel;
    @Shadow
    @Final
    private Merchant trader;
    @Unique
    private int enc_vanilla$unlockedTradeCount = 0;
    @Unique
    private static final int LEVEL_BITMASK = 255;
    @Unique
    private static final int TRADE_COUNT_SHIFT = 8;

    @Shadow
    public abstract MerchantOffers getOffers();

    @Inject(method={"setMerchantLevel(I)V"}, at={@At(value="TAIL")})
    private void readUnlockedTradeCountFromLevel(int i, CallbackInfo ci) {
        this.enc_vanilla$unlockedTradeCount = i >> 8;
        this.merchantLevel = i & 0xFF;
        Merchant merchant = this.trader;
        if (merchant instanceof IClientSideMerchant) {
            IClientSideMerchant clientMerchant = (IClientSideMerchant)merchant;
            try {
                if (this.enc_vanilla$unlockedTradeCount > 0 && this.enc_vanilla$unlockedTradeCount <= this.getOffers().size()) {
                    List unlockedTrades = this.getOffers().subList(0, this.enc_vanilla$unlockedTradeCount);
                    MerchantOffers offers = new MerchantOffers();
                    offers.addAll((Collection)unlockedTrades);
                    clientMerchant.enc_vanilla$setClientUnlockedTrades(offers);
                } else {
                    clientMerchant.enc_vanilla$setClientUnlockedTrades(new MerchantOffers());
                }
            }
            catch (Exception e) {
                clientMerchant.enc_vanilla$setClientUnlockedTrades(new MerchantOffers());
            }
        }
    }

    @Override
    public boolean enc_vanilla$shouldAllowTrade(int i) {
        if (this.enc_vanilla$unlockedTradeCount == 0) {
            return true;
        }
        return i < this.enc_vanilla$unlockedTradeCount;
    }
}

