/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.api.IPhantom;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Phantom.class})
public abstract class PhantomMixin
extends Mob
implements Enemy,
IPhantom {
    @Unique
    private static final EntityDataAccessor<Integer> BELL_TIME = SynchedEntityData.defineId(Phantom.class, (EntityDataSerializer)EntityDataSerializers.INT);

    protected PhantomMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"defineSynchedData(Lnet/minecraft/network/syncher/SynchedEntityData$Builder;)V"}, at={@At(value="TAIL")})
    protected void defineSynchedDataInject(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(BELL_TIME, (Object)0);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveDataInject(ValueInput valueInput, CallbackInfo ci) {
        this.enc_vanilla$setBellTime((Integer)valueInput.getInt("BellTime").get());
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveDataInject(ValueOutput valueOutput, CallbackInfo ci) {
        valueOutput.putInt("BellTime", this.enc_vanilla$getBellTime());
    }

    @Override
    public void enc_vanilla$setBellTime(int i) {
        this.entityData.set(BELL_TIME, (Object)i, true);
    }

    @Unique
    public int enc_vanilla$getBellTime() {
        return (Integer)this.entityData.get(BELL_TIME);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0))
    private void tickRedirect(Level instance, ParticleOptions arg, double d, double e, double f, double g, double h, double i) {
        int bellTime = this.enc_vanilla$getBellTime();
        if (bellTime > 0) {
            this.enc_vanilla$setBellTime(bellTime - 1);
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, d, e, f, g, h, i);
        } else {
            this.level().addParticle((ParticleOptions)ParticleTypes.MYCELIUM, d, e, f, g, h, i);
        }
    }
}

