/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Entity {
    @Shadow
    @NotNull
    public abstract ServerLevel level();

    public ServerPlayerMixin(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Inject(method={"startSleepInBed(Lnet/minecraft/core/BlockPos;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="RETURN")})
    public void highlightMobs(BlockPos at, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enableHighlightMobs) {
            return;
        }
        Optional reason = ((Either)cir.getReturnValue()).left();
        if (reason.isPresent() && reason.get() == Player.BedSleepingProblem.NOT_SAFE) {
            Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)at);
            int duration = (int)(((QolConfig)QolConfig.HANDLER.instance()).highlightDuration * 20.0);
            for (Monster entity : this.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x - 8.0, vec3.y - 5.0, vec3.z - 8.0, vec3.x + 8.0, vec3.y + 5.0, vec3.z + 8.0), hostileEntity -> hostileEntity.isPreventingPlayerRest(this.level(), (Player)this))) {
                entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, duration, 1, false, false));
            }
        }
    }
}

