/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SweetBerryBushBlock.class})
public abstract class SweetBerryBushBlockMixin
extends VegetationBlock
implements BonemealableBlock {
    protected SweetBerryBushBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"entityInside(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/InsideBlockEffectApplier;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void entityInsideInject(BlockState blockState, Level level, BlockPos blockPos, Entity entity, InsideBlockEffectApplier insideBlockEffectApplier, CallbackInfo ci) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enableBushProtection) {
            return;
        }
        if (((QolConfig)QolConfig.HANDLER.instance()).permanentVillagersProtection && entity.getType() == EntityType.VILLAGER) {
            this.enc_vanilla$stuckInBlock(entity, blockState);
            ci.cancel();
        } else if (entity.getType() == EntityType.PLAYER) {
            if (((QolConfig)QolConfig.HANDLER.instance()).needLeggings) {
                Player player = (Player)entity;
                if (!player.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
                    this.enc_vanilla$stuckInBlock(entity, blockState);
                    ci.cancel();
                }
            } else {
                this.enc_vanilla$stuckInBlock(entity, blockState);
                ci.cancel();
            }
        }
    }

    @Unique
    private void enc_vanilla$stuckInBlock(Entity entity, BlockState blockState) {
        if (((QolConfig)QolConfig.HANDLER.instance()).enableSlowerSpeed) {
            entity.makeStuckInBlock(blockState, new Vec3((double)0.8f, 0.75, (double)0.8f));
        }
    }
}

