/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.api.IVillager;
import com.euphony.enc_vanilla.common.entity.DoubleHandedTemptGoal;
import com.euphony.enc_vanilla.common.entity.VillagerAttractionGoal;
import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.utils.LockedTradeData;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements IVillager {
    @Unique
    private DoubleHandedTemptGoal enc_vanilla$villagersAttractedGoal;
    @Unique
    private boolean enc_vanilla$villagersAttracted;
    @Unique
    private final Mutable<LockedTradeData> enc_vanilla$lockedTradeData = new MutableObject();
    @Unique
    private int enc_vanilla$lastKnownLevel = -1;
    @Unique
    private boolean enc_vanilla$isDirty = false;

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder addAttributes(AttributeSupplier.Builder builder) {
        return builder.add(Attributes.TEMPT_RANGE, 10.0);
    }

    @Inject(method={"Lnet/minecraft/world/entity/npc/Villager;<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Holder;)V"}, at={@At(value="RETURN")})
    private void init(EntityType<? extends Villager> entityType, Level level, Holder<VillagerType> holder, CallbackInfo ci) {
        this.enc_vanilla$villagersAttractedGoal = new VillagerAttractionGoal((PathfinderMob)this);
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void checkVillagersAttracted(CallbackInfo ci) {
        boolean configEnabled = ((QolConfig)QolConfig.HANDLER.instance()).enableVillagerAttraction;
        if (!this.enc_vanilla$villagersAttracted && configEnabled) {
            this.goalSelector.addGoal(0, (Goal)this.enc_vanilla$villagersAttractedGoal);
            this.enc_vanilla$villagersAttracted = true;
        } else if (this.enc_vanilla$villagersAttracted && !configEnabled) {
            this.goalSelector.removeGoal((Goal)this.enc_vanilla$villagersAttractedGoal);
            this.enc_vanilla$villagersAttracted = false;
        }
    }

    @Shadow
    @NotNull
    public abstract VillagerData getVillagerData();

    @Unique
    private void enc_vanilla$ifPresent(Consumer<LockedTradeData> consumer) {
        LockedTradeData data = (LockedTradeData)this.enc_vanilla$lockedTradeData.getValue();
        if (data != null) {
            try {
                consumer.accept(data);
            }
            catch (Exception e) {
                this.enc_vanilla$lockedTradeData.setValue(null);
                this.enc_vanilla$isDirty = true;
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="HEAD")})
    private void saveLockedTradeData(ValueOutput valueOutput, CallbackInfo ci) {
        this.enc_vanilla$ifPresent(data -> data.write(valueOutput));
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    private void readLockedTradeData(ValueInput valueInput, CallbackInfo ci) {
        try {
            LockedTradeData data = LockedTradeData.constructOrNull(valueInput);
            this.enc_vanilla$lockedTradeData.setValue((Object)data);
            this.enc_vanilla$isDirty = data == null;
        }
        catch (Exception e) {
            this.enc_vanilla$lockedTradeData.setValue(null);
            this.enc_vanilla$isDirty = true;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void removeLockedTradeDataIfNoOffers(CallbackInfo ci) {
        if (this.offers == null || this.offers.isEmpty()) {
            if (this.enc_vanilla$lockedTradeData.getValue() != null) {
                this.enc_vanilla$lockedTradeData.setValue(null);
                this.enc_vanilla$isDirty = false;
            }
            return;
        }
        int currentLevel = this.getVillagerData().level();
        if (this.enc_vanilla$lastKnownLevel != currentLevel) {
            this.enc_vanilla$lastKnownLevel = currentLevel;
            this.enc_vanilla$isDirty = true;
        }
        if (this.enc_vanilla$isDirty) {
            this.enc_vanilla$regenerateLockedTradeData();
            this.enc_vanilla$isDirty = false;
        }
        this.enc_vanilla$ifPresent(data -> data.tick((Villager)this, this::appendLockedOffer));
    }

    @Inject(method={"updateTrades()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventAdditionalTradesOnRankIncrease(CallbackInfo ci) {
        if (this.offers == null || this.offers.isEmpty()) {
            this.enc_vanilla$lockedTradeData.setValue(null);
            this.enc_vanilla$isDirty = false;
            return;
        }
        if (this.appendLockedOffer()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean appendLockedOffer() {
        if (this.offers == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.enc_vanilla$ifPresent(data -> {
            MerchantOffers dismissedTrades = data.popTradeSet();
            if (dismissedTrades != null && !dismissedTrades.isEmpty()) {
                MerchantOffers validTrades = new MerchantOffers();
                for (MerchantOffer offer : dismissedTrades) {
                    if (offer == null || offer.getResult().isEmpty()) continue;
                    validTrades.add((Object)offer);
                }
                if (!validTrades.isEmpty()) {
                    this.offers.addAll((Collection)validTrades);
                    result.set(true);
                }
            }
        });
        return result.get();
    }

    @Unique
    private void enc_vanilla$regenerateLockedTradeData() {
        try {
            this.enc_vanilla$lockedTradeData.setValue((Object)new LockedTradeData((Villager)this));
        }
        catch (Exception e) {
            this.enc_vanilla$lockedTradeData.setValue(null);
        }
    }

    @Override
    public Optional<LockedTradeData> enc_vanilla$getLockedTradeData() {
        return Optional.ofNullable((LockedTradeData)this.enc_vanilla$lockedTradeData.getValue());
    }

    @Override
    public int enc_vanilla$getShiftedLevel() {
        int level = this.getVillagerData().level();
        if (this.offers == null) {
            return level;
        }
        int tradeCount = this.offers.size();
        return level | tradeCount << 8;
    }

    @Override
    public MerchantOffers enc_vanilla$getCombinedOffers() {
        MerchantOffers combinedOffers = new MerchantOffers();
        if (this.offers != null) {
            combinedOffers.addAll((Collection)this.offers);
        }
        if (this.enc_vanilla$lockedTradeData.getValue() == null) {
            this.enc_vanilla$regenerateLockedTradeData();
        }
        this.enc_vanilla$ifPresent(data -> {
            MerchantOffers lockedOffers = data.buildLockedOffers();
            if (lockedOffers != null) {
                combinedOffers.addAll((Collection)lockedOffers);
            }
        });
        return combinedOffers;
    }

    @Unique
    public boolean enc_vanilla$hasLockedTrades() {
        return this.enc_vanilla$lockedTradeData.getValue() != null && !((LockedTradeData)this.enc_vanilla$lockedTradeData.getValue()).hasNoOffers();
    }

    @Unique
    public int enc_vanilla$getLockedTradesCount() {
        return this.enc_vanilla$getLockedTradeData().map(LockedTradeData::getTotalLockedTradesCount).orElse(0);
    }
}

