/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.common.block.WaterloggedLilyPadBlock;
import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WaterlilyBlock.class})
public abstract class WaterlilyBlockMixin
extends Block {
    public WaterlilyBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockPos below;
        Item item = stack.getItem();
        if (level.isClientSide) {
            return InteractionResult.CONSUME;
        }
        if (!WaterlilyBlockMixin.enc_vanilla$canPlaceBlock(player, pos, stack) || !((QolConfig)QolConfig.HANDLER.instance()).enableBlocksOnLilyPad) {
            return InteractionResult.PASS;
        }
        if (!stack.isEmpty() && !(item instanceof PlaceOnWaterBlockItem) && !(stack.getItem() instanceof BoneMealItem) && level.getBlockState(below = pos.below()).is(Blocks.WATER)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            level.setBlock(below, ((WaterloggedLilyPadBlock)((Object)EVBlocks.WATERLOGGED_LILY_PAD.get())).withPropertiesOf(state), 2);
            level.scheduleTick(below, (Block)EVBlocks.WATERLOGGED_LILY_PAD.get(), 1);
        }
        return InteractionResult.PASS;
    }

    @Unique
    private static boolean enc_vanilla$canPlaceBlock(Player player, BlockPos pos, ItemStack stack) {
        AdventureModePredicate adventureModePredicate;
        boolean result;
        GameType gameMode = player.gameMode();
        boolean bl = result = !player.blockActionRestricted(player.level(), pos, gameMode);
        if (!result && gameMode == GameType.ADVENTURE && !stack.isEmpty() && (adventureModePredicate = (AdventureModePredicate)stack.get(DataComponents.CAN_PLACE_ON)) != null && adventureModePredicate.test(new BlockInWorld((LevelReader)player.level(), pos, false))) {
            return true;
        }
        return result;
    }
}

