/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.neoforge.datagen;

import com.euphony.enc_vanilla.neoforge.datagen.LootGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.ModelGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.RegistryDataGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.loots.GlobalLootModifierGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.recipes.RecipeGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.tag.BlockTagGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.tag.DamageTypeGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.tag.ItemTagGenerator;
import com.euphony.enc_vanilla.neoforge.datagen.tag.PaintingVariantTagGenerator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="enc_vanilla")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(output, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(true, (DataProvider)new ModelGenerator(output));
        generator.addProvider(true, (DataProvider)new PaintingVariantTagGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)datapackProvider);
        generator.addProvider(true, (DataProvider)new BlockTagGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new DamageTypeGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new GlobalLootModifierGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new LootGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new RecipeGenerator.Runner(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Enchanting Vanilla"), DetectedVersion.BUILT_IN.packVersion(PackType.CLIENT_RESOURCES), Optional.empty())));
    }
}

