/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.neoforge.datagen;

import com.euphony.enc_vanilla.client.property.FrogBucketActive;
import com.euphony.enc_vanilla.client.property.SculkCompassAngle;
import com.euphony.enc_vanilla.common.block.CutVineBlock;
import com.euphony.enc_vanilla.common.block.WaterloggedLilyPadBlock;
import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.euphony.enc_vanilla.common.init.EVItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class ModelGenerator
extends ModelProvider {
    public ModelGenerator(PackOutput output) {
        super(output, "enc_vanilla");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.generateFrogBucket(itemModels, (Item)EVItems.FROG_BUCKET_ITEM.get());
        this.generateSculkCompass(itemModels, (Item)EVItems.SCULK_COMPASS_ITEM.get());
        this.itemModel(itemModels, (Item)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get());
        this.itemModel(itemModels, (Item)EVItems.BIOME_CRYSTAL_ITEM.get());
        this.itemModel(itemModels, (Item)EVItems.HEATED_BIOME_CRYSTAL_ITEM.get());
        this.itemModel(itemModels, (Item)EVItems.FROZEN_BIOME_CRYSTAL_ITEM.get());
        this.createBambooSapling(blockModels, (Block)EVBlocks.CUT_BAMBOO_SAPLING.get());
        this.createVine(blockModels);
        this.createSugarCane(blockModels, (Block)EVBlocks.CUT_SUGAR_CANE.get());
        this.createNormalTorch(blockModels, (Block)EVBlocks.CEILING_TORCH.get(), Blocks.TORCH);
        this.createNormalTorch(blockModels, (Block)EVBlocks.CEILING_SOUL_TORCH.get(), Blocks.SOUL_TORCH);
        this.createRedstoneTorch(blockModels, (Block)EVBlocks.CEILING_REDSTONE_TORCH.get());
        this.createLilyPad(blockModels);
        this.createAppraisalTable(blockModels, (Block)EVBlocks.APPRAISAL_TABLE.get());
    }

    public void generateFrogBucket(ItemModelGenerators itemModels, Item item) {
        ItemModel.Unbaked itemmodel$unbaked = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, ModelTemplates.FLAT_ITEM));
        ItemModel.Unbaked itemmodel$unbaked1 = ItemModelUtils.plainModel((ResourceLocation)itemModels.createFlatItemModel(item, "_active", ModelTemplates.FLAT_ITEM));
        itemModels.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new FrogBucketActive(false), (ItemModel.Unbaked)itemmodel$unbaked, (SelectItemModel.SwitchCase[])new SelectItemModel.SwitchCase[]{new SelectItemModel.SwitchCase(List.of(Boolean.valueOf(true)), itemmodel$unbaked1)}));
    }

    public void generateSculkCompass(ItemModelGenerators itemModels, Item item) {
        List list = itemModels.createCompassModels(item);
        itemModels.itemModelOutput.accept(item, ItemModelUtils.rangeSelect((RangeSelectItemModelProperty)new SculkCompassAngle(true), (float)32.0f, (List)list));
    }

    public void createBambooSapling(BlockModelGenerators blockModels, Block block) {
        blockModels.createCrossBlock(block, BlockModelGenerators.PlantType.TINTED, TextureMapping.cross((ResourceLocation)TextureMapping.getBlockTexture((Block)Blocks.BAMBOO, (String)"_stage0")));
        blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Item)Items.BAMBOO));
    }

    public void createAppraisalTable(BlockModelGenerators blockModels, Block block) {
        ResourceLocation resourcelocation = TextureMapping.getBlockTexture((Block)Blocks.SPRUCE_PLANKS);
        ResourceLocation resourcelocation1 = TextureMapping.getBlockTexture((Block)block, (String)"_top");
        ResourceLocation resourcelocation2 = TextureMapping.getBlockTexture((Block)block, (String)"_side");
        TextureMapping texturemapping = new TextureMapping().put(TextureSlot.BOTTOM, resourcelocation).put(TextureSlot.TOP, resourcelocation1).put(TextureSlot.SIDE, resourcelocation2);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CUBE_BOTTOM_TOP.create((Block)EVBlocks.APPRAISAL_TABLE.get(), texturemapping, blockModels.modelOutput))));
        ResourceLocation resourcelocation3 = ModelLocationUtils.getModelLocation((Block)((Block)EVBlocks.APPRAISAL_TABLE.get()));
        blockModels.registerSimpleItemModel(block, resourcelocation3);
    }

    public void createSugarCane(BlockModelGenerators blockModels, Block block) {
        blockModels.createCrossBlock(block, BlockModelGenerators.PlantType.TINTED);
        blockModels.registerSimpleItemModel(block, ModelLocationUtils.getModelLocation((Item)Items.SUGAR_CANE));
    }

    public void createLilyPad(BlockModelGenerators blockModels) {
        ResourceLocation resourcelocation = blockModels.createFlatItemModelWithBlockTexture(((WaterloggedLilyPadBlock)((Object)EVBlocks.WATERLOGGED_LILY_PAD.get())).asItem(), Blocks.LILY_PAD);
        blockModels.registerSimpleTintedItemModel((Block)EVBlocks.WATERLOGGED_LILY_PAD.get(), resourcelocation, ItemModelUtils.constantTint((int)-9321636));
        Variant variant = BlockModelGenerators.plainModel((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)EVBlocks.WATERLOGGED_LILY_PAD.get())));
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)EVBlocks.WATERLOGGED_LILY_PAD.get()), (MultiVariant)BlockModelGenerators.createRotatedVariants((Variant)variant)));
    }

    public void createVine(BlockModelGenerators blockModels) {
        blockModels.createMultifaceBlockStates((Block)EVBlocks.CUT_VINE.get());
        ResourceLocation resourcelocation = blockModels.createFlatItemModelWithBlockTexture(((CutVineBlock)((Object)EVBlocks.CUT_VINE.get())).asItem(), (Block)EVBlocks.CUT_VINE.get());
        blockModels.registerSimpleTintedItemModel((Block)EVBlocks.CUT_VINE.get(), resourcelocation, ItemModelUtils.constantTint((int)-12012264));
    }

    public void createNormalTorch(BlockModelGenerators blockModels, Block block, Block originalBlock) {
        TextureMapping texturemapping = TextureMapping.torch((Block)originalBlock);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.variant((Variant)BlockModelGenerators.plainModel((ResourceLocation)ModelTemplates.TORCH.create(block, texturemapping, blockModels.modelOutput))).with(BlockModelGenerators.X_ROT_180)));
        blockModels.registerSimpleFlatItemModel(block);
    }

    public void createRedstoneTorch(BlockModelGenerators blockModels, Block block) {
        TextureMapping texturemapping = TextureMapping.torch((Block)block);
        TextureMapping texturemapping1 = TextureMapping.torch((ResourceLocation)TextureMapping.getBlockTexture((Block)block, (String)"_off"));
        MultiVariant multivariant = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.REDSTONE_TORCH.create(block, texturemapping, blockModels.modelOutput)).with(BlockModelGenerators.X_ROT_180);
        MultiVariant multivariant1 = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.TORCH_UNLIT.createWithSuffix(block, "_off", texturemapping1, blockModels.modelOutput)).with(BlockModelGenerators.X_ROT_180);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)multivariant, (MultiVariant)multivariant1)));
        blockModels.registerSimpleFlatItemModel(block);
    }

    public void blockModel(BlockModelGenerators blockModels, Block block) {
        blockModels.createTrivialCube(block);
    }

    public void toolModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_HANDHELD_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_ITEM);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + itemId.getPath()));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, String loc) {
        this.itemModel(itemModels, item, ModelTemplates.FLAT_ITEM, loc);
    }

    public void itemModel(ItemModelGenerators itemModels, Item item, ModelTemplate template, String loc) {
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)item);
        ResourceLocation textureLoc = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("item/" + loc));
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.LAYER0, textureLoc);
        itemModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(template.create(item, textureMapping, itemModels.modelOutput), Collections.emptyList()));
    }
}

