/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.neoforge.datagen.recipes;

import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.utils.Utils;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class RecipeGenerator
extends RecipeProvider {
    private static HolderLookup.RegistryLookup<Item> registry = null;

    protected RecipeGenerator(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        registry = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.addSpongeCampfireRecipes();
        this.addSculkCompassRecipes();
    }

    protected void addSpongeCampfireRecipes() {
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike)Items.WET_SPONGE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SPONGE, (float)0.15f, (int)600).unlockedBy("has_item", this.has((ItemLike)Items.WET_SPONGE)).save(this.output, this.createKey("wet_sponge_to_sponge"));
    }

    protected void addSculkCompassRecipes() {
        ShapedRecipeBuilder.shaped(registry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EVItems.SCULK_COMPASS_ITEM.get()), (int)1).define(Character.valueOf('S'), (ItemLike)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get()).define(Character.valueOf('I'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).pattern("IAI").pattern("ISI").pattern("III").unlockedBy("has_item", this.has((ItemLike)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get())).save(this.output, this.createKey("sculk_compass"));
        ShapedRecipeBuilder.shaped(registry, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EVBlocks.APPRAISAL_TABLE.get()), (int)1).define(Character.valueOf('S'), (ItemLike)Items.DIAMOND).define(Character.valueOf('A'), ItemTags.LOGS).define(Character.valueOf('I'), (ItemLike)Items.ECHO_SHARD).pattern("I I").pattern("SAS").pattern("AAA").unlockedBy("has_item", this.has((ItemLike)Items.DIAMOND)).save(this.output, this.createKey("appraisal_table"));
    }

    protected ResourceLocation createLocation(String name) {
        return Utils.prefix(name);
    }

    protected ResourceKey<Recipe<?>> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)this.createLocation(name));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new RecipeGenerator(registries, output);
        }

        public String getName() {
            return "Enchanting Vanilla's Recipes";
        }
    }
}

