/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.screen;

import com.euphony.enc_vanilla.screen.AppraisalTableMenu;
import com.euphony.enc_vanilla.screen.widget.RefreshImageButton;
import com.euphony.enc_vanilla.utils.Utils;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AppraisalTableScreen
extends AbstractContainerScreen<AppraisalTableMenu> {
    private static final String GLITCH_CHARS = "01!@#$%^&*()_+-=[]{}|;:,.<>?/";
    public static final WidgetSprites REFRESH_SPRITES = new WidgetSprites(Utils.prefix("refresh"), Utils.prefix("refresh_disabled"), Utils.prefix("refresh_highlighted"));
    private static final ResourceLocation PROGRESS_SPRITE = Utils.prefix("container/progress");
    private static final ResourceLocation TEXTURE = Utils.prefix("textures/gui/container/appraisal_table.png");
    private static final String ERROR_MESSAGE = "message.enc_vanilla.sculk_compass.error_messages.";
    private static final int UPDATE_INTERVAL = 3;
    Random random = new Random();
    private boolean isErrorMessage = false;
    private boolean isActive = false;
    public static String message = "";
    private int tickCounter = 0;
    public static StringWidget glitchWidget = new StringWidget((Component)Component.literal((String)message), Minecraft.getInstance().font);
    RefreshImageButton refreshImageButton;

    public AppraisalTableScreen(AppraisalTableMenu itemCombinerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)itemCombinerMenu, inventory, component);
    }

    protected void init() {
        super.init();
        this.refreshImageButton = new RefreshImageButton(this.leftPos + 103, this.topPos + 11, 18, 18, REFRESH_SPRITES, button -> this.minecraft.gameMode.handleInventoryButtonClick(((AppraisalTableMenu)this.menu).containerId, 0));
        this.refreshImageButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.refreshImageButton);
        glitchWidget = new StringWidget(this.leftPos + 55, this.topPos + 58, 100, 20, (Component)Component.literal((String)message), Minecraft.getInstance().font);
        glitchWidget.alignLeft();
        glitchWidget.setColor(0xAAAAAA);
        this.addRenderableWidget((GuiEventListener)glitchWidget);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        int k = this.leftPos;
        int l = this.topPos;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, k, l, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((AppraisalTableMenu)this.menu).isInProgress()) {
            int m = 75;
            int n = Mth.ceil((float)(((AppraisalTableMenu)this.menu).getProgress() * (float)m)) + 1;
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, PROGRESS_SPRITE, 74, 15, 0, 0, k + 51, l + 36, n, 15);
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (((AppraisalTableMenu)this.menu).isInProgress()) {
            if (++this.tickCounter >= 3) {
                this.regenerateText();
                if (this.isErrorMessage) {
                    this.isErrorMessage = false;
                }
                this.tickCounter = 0;
            }
        } else if (!glitchWidget.getMessage().getString().isEmpty()) {
            if (!((AppraisalTableMenu)this.menu).getIsError()) {
                glitchWidget.setMessage((Component)Component.literal((String)""));
            } else if (!this.isErrorMessage) {
                glitchWidget.setMessage((Component)Component.translatable((String)(ERROR_MESSAGE + (this.random.nextInt(3) + 1))).withStyle(ChatFormatting.RED));
                this.isErrorMessage = true;
            }
        }
        if (((AppraisalTableMenu)this.menu).getIsActive() != this.isActive) {
            this.refreshImageButton.active = this.isActive = ((AppraisalTableMenu)this.menu).getIsActive();
        }
    }

    private void regenerateText() {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        int length = 5 + random.nextInt(8);
        for (int i = 0; i < length; ++i) {
            sb.append(GLITCH_CHARS.charAt(random.nextInt(GLITCH_CHARS.length())));
        }
        glitchWidget.setMessage((Component)Component.literal((String)sb.toString()));
    }

    public AppraisalTableMenu getMenu() {
        return (AppraisalTableMenu)super.getMenu();
    }
}

