/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedTradeData {
    private static final Logger visibleTradersLogger = LoggerFactory.getLogger((String)"Visible Traders");
    private static final int MAX_VILLAGER_LEVEL = 5;
    private List<MerchantOffers> lockedOffers;

    public LockedTradeData(Villager villager) {
        this.lockedOffers = LockedTradeData.generateTrades(villager);
    }

    private LockedTradeData(List<MerchantOffers> offers) {
        this.lockedOffers = offers != null ? new ArrayList<MerchantOffers>(offers) : new ArrayList();
    }

    @Nullable
    public static LockedTradeData constructOrNull(ValueInput valueInput) {
        Optional offers = valueInput.read("LockedOffers", MerchantOffers.CODEC.listOf());
        return offers.map(LockedTradeData::new).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<MerchantOffers> generateTrades(Villager villager) {
        if (villager == null) {
            visibleTradersLogger.warn("Attempting to generate trades for null villager");
            return new ArrayList<MerchantOffers>();
        }
        MerchantOffers currentOffers = villager.getOffers();
        VillagerData originalData = villager.getVillagerData();
        ArrayList<MerchantOffers> lockedOffers = new ArrayList<MerchantOffers>();
        int currentLevel = originalData.level();
        try {
            for (int targetLevel = currentLevel + 1; targetLevel <= 5; ++targetLevel) {
                villager.setVillagerData(originalData.withLevel(targetLevel));
                int preUpdateSize = currentOffers.size();
                villager.updateTrades();
                int postUpdateSize = currentOffers.size();
                int newTradesCount = postUpdateSize - preUpdateSize;
                if (newTradesCount > 0) {
                    MerchantOffers newOffers = new MerchantOffers();
                    for (int i = 0; i < newTradesCount; ++i) {
                        MerchantOffer offer = (MerchantOffer)currentOffers.removeLast();
                        if (!LockedTradeData.isValidOffer(offer)) continue;
                        newOffers.add(0, (Object)offer);
                    }
                    if (newOffers.isEmpty()) continue;
                    lockedOffers.add(newOffers);
                    continue;
                }
                if (newTradesCount >= 0) continue;
                visibleTradersLogger.warn("Trade count decreased unexpectedly for villager at level {}", (Object)targetLevel);
            }
        }
        catch (Exception e) {
            visibleTradersLogger.error("Error generating trades for villager", (Throwable)e);
            lockedOffers.clear();
        }
        finally {
            villager.setVillagerData(originalData);
        }
        return lockedOffers;
    }

    private static boolean isValidOffer(MerchantOffer offer) {
        return offer != null && !offer.getResult().isEmpty() && !offer.getCostA().isEmpty();
    }

    public void write(ValueOutput valueOutput) {
        if (this.lockedOffers != null && !this.lockedOffers.isEmpty()) {
            valueOutput.store("LockedOffers", MerchantOffers.CODEC.listOf(), this.lockedOffers);
        }
    }

    public boolean hasNoOffers() {
        return this.lockedOffers == null || this.lockedOffers.isEmpty();
    }

    public MerchantOffers popTradeSet() {
        if (this.hasNoOffers()) {
            return null;
        }
        return this.lockedOffers.removeFirst();
    }

    public MerchantOffers buildLockedOffers() {
        MerchantOffers combinedOffers = new MerchantOffers();
        if (this.hasNoOffers()) {
            return combinedOffers;
        }
        boolean hasInvalidOffer = false;
        for (MerchantOffers levelOffers : this.lockedOffers) {
            if (levelOffers == null) continue;
            for (MerchantOffer offer : levelOffers) {
                if (!LockedTradeData.isValidOffer(offer)) {
                    hasInvalidOffer = true;
                    visibleTradersLogger.warn("Detected invalid trade offer: {}", (Object)offer);
                    continue;
                }
                combinedOffers.add((Object)offer);
            }
        }
        if (hasInvalidOffer) {
            visibleTradersLogger.warn("Found invalid offers, clearing locked trade data");
            this.lockedOffers = new ArrayList<MerchantOffers>();
            return new MerchantOffers();
        }
        return combinedOffers;
    }

    public void tick(Villager villager, Runnable popCallback) {
        int currentSets;
        if (this.lockedOffers == null) {
            this.lockedOffers = new ArrayList<MerchantOffers>();
            return;
        }
        int villagerLevel = villager.getVillagerData().level();
        int requiredSets = 5 - villagerLevel;
        for (currentSets = this.lockedOffers.size(); currentSets > requiredSets && !this.lockedOffers.isEmpty(); --currentSets) {
            popCallback.run();
        }
        if (currentSets < requiredSets) {
            visibleTradersLogger.debug("Rebuilding locked offers: expected {}, got {}", (Object)requiredSets, (Object)currentSets);
            this.lockedOffers = LockedTradeData.generateTrades(villager);
        }
    }

    public int getTotalLockedTradesCount() {
        if (this.hasNoOffers()) {
            return 0;
        }
        return this.lockedOffers.stream().mapToInt(offers -> offers.size()).sum();
    }
}

