/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class LoadConfigUtils {
    public static int loadConfigAsInt(String option, int defaultValue) {
        JsonElement jsonTree;
        String json;
        Path configPath = Platform.getConfigFolder().resolve("enc_vanilla").resolve("qol.json");
        if (Files.notExists(configPath, new LinkOption[0])) {
            return defaultValue;
        }
        try {
            json = Files.readString(configPath);
        }
        catch (IOException e) {
            return defaultValue;
        }
        try {
            jsonTree = JsonParser.parseString((String)json);
        }
        catch (JsonParseException e) {
            return defaultValue;
        }
        try {
            return jsonTree.getAsJsonObject().get(option).getAsInt();
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }

    public static boolean loadConfigAsBoolean(String option, boolean defaultValue) {
        JsonElement jsonTree;
        String json;
        Path configPath = Platform.getConfigFolder().resolve("enc_vanilla").resolve("qol.json");
        if (Files.notExists(configPath, new LinkOption[0])) {
            return defaultValue;
        }
        try {
            json = Files.readString(configPath);
        }
        catch (IOException e) {
            return defaultValue;
        }
        try {
            jsonTree = JsonParser.parseString((String)json);
        }
        catch (JsonParseException e) {
            return defaultValue;
        }
        try {
            return jsonTree.getAsJsonObject().get(option).getAsBoolean();
        }
        catch (NullPointerException e) {
            return defaultValue;
        }
    }
}

