/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.client;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.client.events.BiomeTitleEvent;
import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.common.item.SculkCompassItem;
import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.config.client.EVConfigScreen;
import com.euphony.enc_vanilla.utils.CompassState;
import com.euphony.enc_vanilla.utils.Utils;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="enc_vanilla", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EVClient {
    @SubscribeEvent
    public static void onResourceManagerReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((barrier, manager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> CompletableFuture.runAsync(BiomeTitleEvent.NAME_CACHE::clear, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0)));
    }

    @SubscribeEvent
    public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.TITLE, ResourceLocation.fromNamespaceAndPath((String)"enc_vanilla", (String)"overlay"), BiomeTitleEvent::renderBiomeInfo);
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        BiomeTitleEvent.setComplete(true);
    }

    @SubscribeEvent
    public static void registerBlockColor(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> 2129968, new Block[]{(Block)EVBlocks.WATERLOGGED_LILY_PAD.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : FoliageColor.getDefaultColor(), new Block[]{(Block)EVBlocks.CUT_VINE.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : -1, new Block[]{(Block)EVBlocks.CUT_SUGAR_CANE.get()});
    }

    @SubscribeEvent
    public static void registerItemColor(RegisterColorHandlersEvent.Item event) {
        BlockColors colors = event.getBlockColors();
        event.register((p_92687_, p_92688_) -> {
            BlockState blockstate = ((BlockItem)p_92687_.getItem()).getBlock().defaultBlockState();
            return colors.getColor(blockstate, null, null, p_92688_);
        }, new ItemLike[]{(ItemLike)EVBlocks.CUT_VINE.get()});
    }

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            if (Utils.isModLoaded("yet_another_config_lib_v3")) {
                ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (client, screen) -> new EVConfigScreen(screen));
            }
            ItemProperties.register((Item)Items.AXOLOTL_BUCKET, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"variant"), (stack, level, entity, seed) -> {
                CustomData customData;
                if (!((QolConfig)QolConfig.HANDLER.instance()).enableAxolotlBucketFix) {
                    return 0.0f;
                }
                int axolotlType = 0;
                if (stack.getComponents().has(DataComponents.BUCKET_ENTITY_DATA) && (customData = (CustomData)stack.getComponents().get(DataComponents.BUCKET_ENTITY_DATA)) != null) {
                    axolotlType = customData.copyTag().getInt("Variant");
                }
                return axolotlType;
            });
            ItemProperties.register((Item)((Item)EVItems.SCULK_COMPASS_ITEM.get()), (ResourceLocation)EncVanilla.prefix("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
                private final CompassWobble wobble = new CompassWobble();
                private final CompassWobble wobbleRandom = new CompassWobble();

                public float unclampedCall(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity p_entity, int seed) {
                    LivingEntity entity;
                    Object object = entity = p_entity != null ? p_entity : stack.getEntityRepresentation();
                    if (entity == null) {
                        return 0.0f;
                    }
                    return (level = this.tryFetchLevelIfMissing((Entity)entity, level)) == null ? 0.0f : this.getCompassRotation(stack, level, seed, (Entity)entity);
                }

                private float getCompassRotation(ItemStack stack, ClientLevel level, int seed, Entity entity) {
                    SculkCompassItem compassTarget = (SculkCompassItem)stack.getItem();
                    BlockPos blockPos = new BlockPos(compassTarget.getFoundBiomeX(stack), 0, compassTarget.getFoundBiomeZ(stack));
                    long i = level.getGameTime();
                    return compassTarget.getState(stack) == CompassState.FOUND ? this.getRotationTowardsCompassTarget(entity, i, blockPos) : this.getRandomlySpinningRotation(seed, i);
                }

                private float getRandomlySpinningRotation(int seed, long ticks) {
                    if (this.wobbleRandom.shouldUpdate(ticks)) {
                        this.wobbleRandom.update(ticks, Math.random());
                    }
                    double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(seed) / 2.1474836E9f);
                    return Mth.positiveModulo((float)((float)d0), (float)1.0f);
                }

                private float getRotationTowardsCompassTarget(Entity entity, long ticks, BlockPos pos) {
                    Player player;
                    double d0 = this.getAngleFromEntityToPos(entity, pos);
                    double d1 = this.getWrappedVisualRotationY(entity);
                    if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
                        if (this.wobble.shouldUpdate(ticks)) {
                            this.wobble.update(ticks, 0.5 - (d1 - 0.25));
                        }
                        double d3 = d0 + this.wobble.rotation;
                        return Mth.positiveModulo((float)((float)d3), (float)1.0f);
                    }
                    double d2 = 0.5 - (d1 - 0.25 - d0);
                    return Mth.positiveModulo((float)((float)d2), (float)1.0f);
                }

                @Nullable
                private ClientLevel tryFetchLevelIfMissing(Entity entity, @Nullable ClientLevel level) {
                    return level == null && entity.level() instanceof ClientLevel ? (ClientLevel)entity.level() : level;
                }

                private double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
                    Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
                    return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
                }

                private double getWrappedVisualRotationY(Entity entity) {
                    return Mth.positiveModulo((double)(entity.getVisualRotationYInDegrees() / 360.0f), (double)1.0);
                }

                private int hash(int value) {
                    return value * 1327217883;
                }

                @OnlyIn(value=Dist.CLIENT)
                static class CompassWobble {
                    double rotation;
                    private double deltaRotation;
                    private long lastUpdateTick;

                    CompassWobble() {
                    }

                    boolean shouldUpdate(long ticks) {
                        return this.lastUpdateTick != ticks;
                    }

                    void update(long ticks, double rotation) {
                        this.lastUpdateTick = ticks;
                        double d0 = rotation - this.rotation;
                        d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
                        this.deltaRotation += d0 * 0.1;
                        this.deltaRotation *= 0.8;
                        this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
                    }
                }
            });
        });
    }
}

