/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.client.events;

import com.euphony.enc_vanilla.config.categories.ClientConfig;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="enc_vanilla", value={Dist.CLIENT})
public class BeeInfoEvent {
    @SubscribeEvent
    public static void handleBeeInfo(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(Items.BEE_NEST) || stack.is(Items.BEEHIVE)) {
            if (!((ClientConfig)ClientConfig.HANDLER.instance()).enableBeeInfo) {
                return;
            }
            DataComponentMap dataComponents = stack.getComponents();
            BlockItemStateProperties blockItemStateProperties = (BlockItemStateProperties)dataComponents.getOrDefault(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY);
            int i = Objects.requireNonNullElse((Integer)blockItemStateProperties.get((Property)BeehiveBlock.HONEY_LEVEL), 0);
            int j = ((List)dataComponents.getOrDefault(DataComponents.BEES, List.of())).size();
            List tooltip = event.getToolTip();
            tooltip.add(Component.translatable((String)"container.beehive.bees", (Object[])new Object[]{j, 3}).withStyle(ChatFormatting.GRAY));
            tooltip.add(Component.translatable((String)"container.beehive.honey", (Object[])new Object[]{i, 5}).withStyle(ChatFormatting.GRAY));
        }
    }
}

