/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.client.events;

import com.euphony.enc_vanilla.config.categories.ClientConfig;
import com.euphony.enc_vanilla.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.apache.commons.lang3.StringUtils;

@EventBusSubscriber(modid="enc_vanilla", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class BiomeTitleEvent {
    public static Biome previousBiome;
    public static ResourceKey<Biome> displayBiome;
    public static int displayTime;
    public static int alpha;
    public static int cooldownTime;
    public static int fadeTimer;
    public static boolean complete;
    public static boolean fadingIn;
    public static final Map<ResourceKey<Biome>, Component> NAME_CACHE;

    private BiomeTitleEvent() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        if (complete) {
            if (!fadingIn) {
                if (displayTime > 0) {
                    --displayTime;
                } else if (fadeTimer > 0) {
                    alpha = (int)(255.0f / (float)((ClientConfig)ClientConfig.HANDLER.instance()).fadeOutTime * (float)(--fadeTimer));
                } else if (cooldownTime > 0) {
                    --cooldownTime;
                }
            } else if (fadeTimer < ((ClientConfig)ClientConfig.HANDLER.instance()).fadeInTime) {
                alpha = (int)(255.0f / (float)((ClientConfig)ClientConfig.HANDLER.instance()).fadeInTime * (float)(++fadeTimer));
            } else {
                fadeTimer = ((ClientConfig)ClientConfig.HANDLER.instance()).fadeOutTime;
                fadingIn = false;
                displayTime = (int)(((ClientConfig)ClientConfig.HANDLER.instance()).displayDuration * 20.0);
                alpha = 255;
            }
        }
    }

    public static void renderBiomeInfo(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (complete && ((ClientConfig)ClientConfig.HANDLER.instance()).enableBiomeTitle) {
            Minecraft mc = Minecraft.getInstance();
            if (BiomeTitleEvent.hideInF1(mc) || BiomeTitleEvent.hideInF3(mc)) {
                return;
            }
            Entity player = mc.getCameraEntity();
            if (player == null) {
                return;
            }
            BlockPos pos = player.getOnPos();
            if (mc.level != null && mc.level.isLoaded(pos)) {
                boolean shouldUpdate;
                Holder biomeHolder = mc.level.getBiome(pos);
                if (!biomeHolder.isBound()) {
                    return;
                }
                Biome biome = (Biome)biomeHolder.value();
                boolean isPlayerUnderground = mc.level.dimensionType().hasSkyLight() && !mc.level.canSeeSky(pos);
                boolean bl = shouldUpdate = ((ClientConfig)ClientConfig.HANDLER.instance()).enableUndergroundUpdate || !isPlayerUnderground;
                if (previousBiome != biome) {
                    previousBiome = biome;
                    if (cooldownTime == 0 && shouldUpdate) {
                        biomeHolder.unwrapKey().ifPresent(key -> {
                            cooldownTime = (int)(((ClientConfig)ClientConfig.HANDLER.instance()).cooldownTime * 20.0);
                            displayBiome = key;
                            displayTime = 0;
                            alpha = 0;
                            fadingIn = true;
                        });
                    }
                }
                if (alpha > 0) {
                    Font font = mc.font;
                    float scale = (float)((ClientConfig)ClientConfig.HANDLER.instance()).scale;
                    PoseStack pose = guiGraphics.pose();
                    pose.pushPose();
                    pose.translate((double)guiGraphics.guiWidth() / 2.0, (double)guiGraphics.guiHeight() / 2.0, 0.0);
                    pose.scale(scale, scale, scale);
                    Component biomeName = BiomeTitleEvent.getBiomeName(displayBiome);
                    int textWidth = font.width((FormattedText)biomeName);
                    int y = -font.wordWrapHeight(biomeName.getString(), 999) / 2 + ((ClientConfig)ClientConfig.HANDLER.instance()).yOffset;
                    guiGraphics.drawString(font, biomeName, -textWidth / 2, y, 0xFFFFFF | alpha << 24, true);
                    pose.popPose();
                }
            }
        }
    }

    private static Component getBiomeName(ResourceKey<Biome> key) {
        return NAME_CACHE.computeIfAbsent(key, k -> {
            String modName;
            MutableComponent biomeName;
            ResourceLocation location = key.location();
            String translationKey = Util.makeDescriptionId((String)"biome", (ResourceLocation)location);
            MutableComponent displayName = biomeName = Component.translatable((String)translationKey);
            String displayedText = biomeName.getString();
            if (displayedText.equals(translationKey)) {
                String biomePath = key.location().getPath();
                String formattedBiomeName = BiomeTitleEvent.snakeCaseToEnglish(biomePath);
                displayName = Component.literal((String)formattedBiomeName);
            }
            if (((ClientConfig)ClientConfig.HANDLER.instance()).enableModName && (modName = BiomeTitleEvent.getModName(location)) != null) {
                displayName = displayName.append((Component)Component.literal((String)String.format(" (%s)", modName)));
            }
            return displayName;
        });
    }

    private static boolean hideInF1(Minecraft mc) {
        return mc.options.hideGui && ((ClientConfig)ClientConfig.HANDLER.instance()).hideInF1;
    }

    private static boolean hideInF3(Minecraft mc) {
        return mc.getDebugOverlay().showDebugScreen() && ((ClientConfig)ClientConfig.HANDLER.instance()).hideInF3;
    }

    private static String snakeCaseToEnglish(String biomePath) {
        String[] words = biomePath.split("_");
        StringJoiner formatted = new StringJoiner(" ");
        for (String word : words) {
            formatted.add(StringUtils.capitalize((String)word));
        }
        return formatted.toString();
    }

    private static String getModName(ResourceLocation location) {
        String modid = location.getNamespace();
        String displayName = Utils.getModDisplayName(modid);
        return displayName == null ? BiomeTitleEvent.snakeCaseToEnglish(modid) : displayName;
    }

    public static void setComplete(boolean complete) {
        BiomeTitleEvent.complete = complete;
    }

    static {
        displayTime = 0;
        alpha = 0;
        cooldownTime = 0;
        fadeTimer = 0;
        complete = false;
        fadingIn = false;
        NAME_CACHE = new HashMap<ResourceKey<Biome>, Component>();
    }
}

