/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.client.events;

import com.euphony.enc_vanilla.config.categories.ClientConfig;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="enc_vanilla", value={Dist.CLIENT})
public class FasterClimbingEvent {
    @SubscribeEvent
    private static void adjustClimbingSpeed(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            return;
        }
        if (player.onClimbable() && !player.isCrouching()) {
            Climber climber = new Climber(player);
            if (((ClientConfig)ClientConfig.HANDLER.instance()).enableFasterDownward && climber.isFacingDownward() && !climber.isMovingForward() && !climber.isMovingBackward()) {
                climber.moveDownFaster();
            } else if (((ClientConfig)ClientConfig.HANDLER.instance()).enableFasterUpward && climber.isFacingUpward() && climber.isMovingForward()) {
                climber.moveUpFaster();
            }
        }
    }

    private record Climber(Player player) {
        private boolean isFacingDownward() {
            return this.player.getXRot() > 0.0f;
        }

        private boolean isFacingUpward() {
            return this.player.getXRot() < 0.0f;
        }

        private boolean isMovingForward() {
            return this.player.zza > 0.0f;
        }

        private boolean isMovingBackward() {
            return this.player.zza < 0.0f;
        }

        private float getSpeed() {
            return (float)(Math.sin(Math.abs((double)this.player.getXRot() * Math.PI / 180.0)) * ((ClientConfig)ClientConfig.HANDLER.instance()).speedMultiplier / 10.0);
        }

        public void moveUpFaster() {
            float dy = this.getSpeed();
            Vec3 move = new Vec3(0.0, (double)dy, 0.0);
            this.player.move(MoverType.SELF, move);
        }

        public void moveDownFaster() {
            float dy = -this.getSpeed();
            Vec3 move = new Vec3(0.0, (double)dy, 0.0);
            this.player.move(MoverType.SELF, move);
        }
    }
}

