/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeilingTorchBlock
extends TorchBlock {
    public static final VoxelShape CEILING_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private final Block originalBlock;

    public CeilingTorchBlock(BlockBehaviour.Properties properties, SimpleParticleType particle, Block originalBlock) {
        super(particle, properties.lootFrom(() -> originalBlock));
        this.originalBlock = originalBlock;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CEILING_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.UP && !this.canSurvive(state, (LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return CeilingTorchBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.above(), (Direction)Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.45;
        double z = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, x, y, z, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.originalBlock);
    }
}

