/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.config.categories;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.utils.config.ConfigUtils;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ToolsConfig {
    public static ConfigClassHandler<ToolsConfig> HANDLER = ConfigClassHandler.createBuilder(ToolsConfig.class).id(EncVanilla.prefix("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setPath(Path.of("config", "enc_vanilla/tools.json")).build()).build();
    private static final String TOOLS_CATEGORY = "tools";
    private static final String COMPRESSED_SLIME_BLOCK_GROUP = "compressed_slime_block";
    private static final String SCULK_COMPASS_GROUP = "sculk_compass";
    private static final String OTHER_GROUP = "other";
    @SerialEntry
    public boolean enableSlimeChunkDetecting = true;
    @SerialEntry
    public boolean enableSculkCompass = true;
    @SerialEntry
    public boolean enableCompressedSlimeBlock = true;

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static YetAnotherConfigLib makeScreen() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> {
            Option enableCompressedSlimeBlockOpt = ConfigUtils.getGenericOption("enableCompressedSlimeBlock", COMPRESSED_SLIME_BLOCK_GROUP).binding((Object)defaults.enableCompressedSlimeBlock, () -> config.enableCompressedSlimeBlock, newVal -> {
                config.enableCompressedSlimeBlock = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableSculkCompassOpt = ConfigUtils.getGenericOption("enableSculkCompass", SCULK_COMPASS_GROUP).binding((Object)defaults.enableSculkCompass, () -> config.enableSculkCompass, newVal -> {
                config.enableSculkCompass = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableSlimeChunkDetectingOpt = ConfigUtils.getGenericOption("enableSlimeChunkDetecting", "slime_chunk").binding((Object)defaults.enableSlimeChunkDetecting, () -> config.enableSlimeChunkDetecting, newVal -> {
                config.enableSlimeChunkDetecting = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            return builder.title((Component)Component.translatable((String)"yacl3.config.enc_vanilla:config")).category(ConfigCategory.createBuilder().name(ConfigUtils.getCategoryName(TOOLS_CATEGORY)).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(TOOLS_CATEGORY, COMPRESSED_SLIME_BLOCK_GROUP)).options(List.of(enableCompressedSlimeBlockOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(TOOLS_CATEGORY, SCULK_COMPASS_GROUP)).options(List.of(enableSculkCompassOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(TOOLS_CATEGORY, OTHER_GROUP)).options(List.of(enableSlimeChunkDetectingOpt)).build()).build()).save(ToolsConfig::save);
        });
    }
}

