/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.config.categories.qol;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.config.categories.qol.screen.ExtraSoulTorchItemsScreen;
import com.euphony.enc_vanilla.config.categories.qol.screen.ExtraTorchItemsScreen;
import com.euphony.enc_vanilla.utils.config.ConfigUtils;
import com.euphony.enc_vanilla.utils.config.DescComponent;
import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.ItemControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public final class QolConfig {
    public static ConfigClassHandler<QolConfig> HANDLER = ConfigClassHandler.createBuilder(QolConfig.class).id(EncVanilla.prefix("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setPath(Path.of("config", "enc_vanilla/qol.json")).build()).build();
    private static final String QOL_CATEGORY = "qol";
    private static final String VILLAGER_ATTRACTION_GROUP = "villager_attraction";
    private static final String ITEM_FRAME_GROUP = "item_frame";
    private static final String TORCH_HIT_GROUP = "torch_hit";
    private static final String TRAMPLING_PREVENTION_GROUP = "trampling_prevention";
    private static final String ANVIL_REPAIR_GROUP = "anvil_repair";
    private static final String WATER_CONVERSION_GROUP = "water_conversion";
    private static final String BELL_PHANTOM_GROUP = "bell_phantom";
    private static final String HIGHLIGHT_MOBS_GROUP = "highlight_mobs";
    private static final String SPONGE_PLACING_GROUP = "sponge_placing";
    private static final String HEALING_CAMPFIRE_GROUP = "healing_campfire";
    private static final String OTHER_GROUP = "other";
    @SerialEntry
    public boolean enableVillagerAttraction = true;
    @SerialEntry
    public Item mainHandItem = Items.EMERALD;
    @SerialEntry
    public boolean enableInvisibleItemFrame = true;
    @SerialEntry
    public boolean enableTorchHit = true;
    @SerialEntry
    public boolean enableMobTorchHit = true;
    @SerialEntry
    public int torchHitFireChance = 50;
    @SerialEntry
    public double torchHitFireDuration = 3.0;
    @SerialEntry
    public List<String> extraTorchItems = List.of("bonetorch:bonetorch", "torchmaster:megatorch", "hardcore_torches:lit_torch", "magnumtorch:diamond_magnum_torch", "magnumtorch:emerald_magnum_torch", "magnumtorch:amethyst_magnum_torch", "magical_torches:mega_torch", "magical_torches:grand_torch", "magical_torches:medium_torch", "magical_torches:small_torch", "pgwbandedtorches:banded_torch_white", "pgwbandedtorches:banded_torch_orange", "pgwbandedtorches:banded_torch_magenta", "pgwbandedtorches:banded_torch_light_blue", "pgwbandedtorches:banded_torch_yellow", "pgwbandedtorches:banded_torch_lime", "pgwbandedtorches:banded_torch_pink", "pgwbandedtorches:banded_torch_gray", "pgwbandedtorches:banded_torch_light_gray", "pgwbandedtorches:banded_torch_cyan", "pgwbandedtorches:banded_torch_purple", "pgwbandedtorches:banded_torch_blue", "pgwbandedtorches:banded_torch_brown", "pgwbandedtorches:banded_torch_green", "pgwbandedtorches:banded_torch_red", "pgwbandedtorches:banded_torch_black");
    @SerialEntry
    public List<String> extraSoulTorchItems = List.of();
    @SerialEntry
    public boolean enableFarmlandTramplingPrevention = true;
    @SerialEntry
    public boolean enableAnvilRepair = true;
    @SerialEntry
    public Item anvilRepairMaterial = Items.IRON_INGOT;
    @SerialEntry
    public boolean enableWaterConversion = true;
    @SerialEntry
    public boolean enableMudConversion = false;
    @SerialEntry
    public boolean enableBellPhantom = true;
    @SerialEntry
    public double particleDuration = 2.0;
    @SerialEntry
    public boolean enableHighlightMobs = true;
    @SerialEntry
    public double highlightDuration = 3.0;
    @SerialEntry
    public boolean enableSpongePlacing = true;
    @SerialEntry
    public boolean enableSpongePlacingSneaking = false;
    @SerialEntry
    public boolean enableHealingCampfire = true;
    @SerialEntry
    public int checkEveryTick = 60;
    @SerialEntry
    public int healingRadius = 16;
    @SerialEntry
    public double effectDuration = 5.0;
    @SerialEntry
    public int effectLevel = 1;
    @SerialEntry
    public boolean enableBlocksOnLilyPad = true;
    @SerialEntry
    public boolean enablePaintingSwitching = true;
    @SerialEntry
    public boolean enableCutVine = true;
    @SerialEntry
    public boolean enableStopGrowing = true;
    @SerialEntry
    public boolean enableShutupNameTag = true;
    @SerialEntry
    public boolean enableJukeboxLoop = true;
    @SerialEntry
    public boolean enableCakeDrop = true;
    @SerialEntry
    public boolean enableCeilingTorch = true;
    @SerialEntry
    public boolean enableSafeLavaBucket = false;
    @SerialEntry
    public boolean enableAxolotlBucketFix = true;
    @SerialEntry
    public boolean enablePlaceChestOnBoat = true;
    @SerialEntry
    public boolean enableNameTagDespawn = true;

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static YetAnotherConfigLib makeScreen() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> {
            Option enableVillagerAttractionOpt = ConfigUtils.getGenericOption("enableVillagerAttraction", VILLAGER_ATTRACTION_GROUP).binding((Object)defaults.enableVillagerAttraction, () -> config.enableVillagerAttraction, newVal -> {
                config.enableVillagerAttraction = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option mainHandItemOpt = ConfigUtils.getGenericOption("mainHandItem").binding((Object)defaults.mainHandItem, () -> config.mainHandItem, newVal -> {
                config.mainHandItem = newVal;
            }).controller(ItemControllerBuilder::create).build();
            Option enableInvisibleItemFrameOpt = ConfigUtils.getGenericOption("enableInvisibleItemFrame", ITEM_FRAME_GROUP).binding((Object)defaults.enableInvisibleItemFrame, () -> config.enableInvisibleItemFrame, newVal -> {
                config.enableInvisibleItemFrame = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableTorchHitOpt = ConfigUtils.getGenericOption("enableTorchHit", TORCH_HIT_GROUP).binding((Object)defaults.enableTorchHit, () -> config.enableTorchHit, newVal -> {
                config.enableTorchHit = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableMobTorchHitOpt = ConfigUtils.getGenericOption("enableMobTorchHit").binding((Object)defaults.enableMobTorchHit, () -> config.enableMobTorchHit, newVal -> {
                config.enableMobTorchHit = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option torchHitFireChanceOpt = ConfigUtils.getGenericOption("torchHitFireChance").binding((Object)defaults.torchHitFireChance, () -> config.torchHitFireChance, newVal -> {
                config.torchHitFireChance = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)1)).formatValue(value -> Component.literal((String)(value + "%")))).build();
            Option torchHitFireDurationOpt = ConfigUtils.getGenericOption("torchHitFireDuration").binding((Object)defaults.torchHitFireDuration, () -> config.torchHitFireDuration, newVal -> {
                config.torchHitFireDuration = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)3.0, (Number)10.0)).step((Number)0.5)).formatValue(value -> Component.literal((String)(value + "s")))).build();
            ButtonOption extraTorchItemsOpt = ConfigUtils.getButtonOption("extraTorchItems").action((yaclScreen, buttonOption) -> yaclScreen.getMinecraft().setScreen(ExtraTorchItemsScreen.makeScreen().generateScreen((Screen)yaclScreen))).build();
            ButtonOption extraSoulTorchItemsOpt = ConfigUtils.getButtonOption("extraSoulTorchItems").action((yaclScreen, buttonOption) -> yaclScreen.getMinecraft().setScreen(ExtraSoulTorchItemsScreen.makeScreen().generateScreen((Screen)yaclScreen))).build();
            Option enableFarmlandTramplingPreventionOpt = ConfigUtils.getGenericOption("enableFarmlandTramplingPrevention").binding((Object)defaults.enableFarmlandTramplingPrevention, () -> config.enableFarmlandTramplingPrevention, newVal -> {
                config.enableFarmlandTramplingPrevention = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableAnvilRepairOpt = ConfigUtils.getGenericOption("enableAnvilRepair").binding((Object)defaults.enableAnvilRepair, () -> config.enableAnvilRepair, newVal -> {
                config.enableAnvilRepair = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option anvilRepairMaterialOpt = ConfigUtils.getGenericOption("anvilRepairMaterial").binding((Object)defaults.anvilRepairMaterial, () -> config.anvilRepairMaterial, newVal -> {
                config.anvilRepairMaterial = newVal;
            }).controller(ItemControllerBuilder::create).build();
            Option enableWaterConversionOpt = ConfigUtils.getGenericOption("enableWaterConversion", WATER_CONVERSION_GROUP).binding((Object)defaults.enableWaterConversion, () -> config.enableWaterConversion, newVal -> {
                config.enableWaterConversion = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableMudConversionOpt = ConfigUtils.getGenericOption("enableMudConversion").binding((Object)defaults.enableMudConversion, () -> config.enableMudConversion, newVal -> {
                config.enableMudConversion = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableBellPhantomOpt = ConfigUtils.getGenericOption("enableBellPhantom").binding((Object)defaults.enableBellPhantom, () -> config.enableBellPhantom, newVal -> {
                config.enableBellPhantom = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option particleDurationOpt = ConfigUtils.getGenericOption("particleDuration").binding((Object)defaults.particleDuration, () -> config.particleDuration, newVal -> {
                config.particleDuration = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.0, (Number)5.0)).step((Number)0.5)).formatValue(value -> Component.literal((String)(value + "s")))).build();
            Option enableHighlightMobsOpt = ConfigUtils.getGenericOption("enableHighlightMobs", HIGHLIGHT_MOBS_GROUP).binding((Object)defaults.enableHighlightMobs, () -> config.enableHighlightMobs, newVal -> {
                config.enableHighlightMobs = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option highlightDurationOpt = ConfigUtils.getGenericOption("highlightDuration").binding((Object)defaults.highlightDuration, () -> config.highlightDuration, newVal -> {
                config.highlightDuration = newVal;
            }).controller(opt -> ((DoubleSliderControllerBuilder)((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)1.0, (Number)5.0)).step((Number)0.5)).formatValue(value -> Component.literal((String)(value + "s")))).build();
            Option enableSpongePlacingOpt = ConfigUtils.getGenericOption("enableSpongePlacing", SPONGE_PLACING_GROUP).binding((Object)defaults.enableSpongePlacing, () -> config.enableSpongePlacing, newVal -> {
                config.enableSpongePlacing = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableSpongePlacingSneakingOpt = ConfigUtils.getGenericOption("enableSpongePlacingSneaking").binding((Object)defaults.enableSpongePlacingSneaking, () -> config.enableSpongePlacingSneaking, newVal -> {
                config.enableSpongePlacingSneaking = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableHealingCampfireOpt = ConfigUtils.getGenericOption("enableHealingCampfire").binding((Object)defaults.enableHealingCampfire, () -> config.enableHealingCampfire, newVal -> {
                config.enableHealingCampfire = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option checkEveryTickOpt = ConfigUtils.getGenericOption("checkEveryTick", DescComponent.TICK_EXPLANATION).binding((Object)defaults.checkEveryTick, () -> config.checkEveryTick, newVal -> {
                config.checkEveryTick = newVal;
            }).controller(opt -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)opt).range((Number)1, (Number)60)).formatValue(value -> Component.literal((String)(value + " ticks")))).build();
            Option healingRadiusOpt = ConfigUtils.getGenericOption("healingRadius").binding((Object)defaults.healingRadius, () -> config.healingRadius, newVal -> {
                config.healingRadius = newVal;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)60)).build();
            Option effectDurationOpt = ConfigUtils.getGenericOption("effectDuration").binding((Object)defaults.effectDuration, () -> config.effectDuration, newVal -> {
                config.effectDuration = newVal;
            }).controller(opt -> ((DoubleFieldControllerBuilder)DoubleFieldControllerBuilder.create((Option)opt).range((Number)1.0, (Number)5.0)).formatValue(value -> Component.literal((String)(value + "s")))).build();
            Option effectLevelOpt = ConfigUtils.getGenericOption("effectLevel").binding((Object)defaults.effectLevel, () -> config.effectLevel, newVal -> {
                config.effectLevel = newVal;
            }).controller(opt -> IntegerFieldControllerBuilder.create((Option)opt).range((Number)0, (Number)60)).build();
            Option enableBlocksOnLilyPadOpt = ConfigUtils.getGenericOption("enableBlocksOnLilyPad", "blocks_on_lily_pad").binding((Object)defaults.enableBlocksOnLilyPad, () -> config.enableBlocksOnLilyPad, newVal -> {
                config.enableBlocksOnLilyPad = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enablePaintingSwitchingOpt = ConfigUtils.getGenericOption("enablePaintingSwitching").binding((Object)defaults.enablePaintingSwitching, () -> config.enablePaintingSwitching, newVal -> {
                config.enablePaintingSwitching = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableCutVineOpt = ConfigUtils.getGenericOption("enableCutVine", "cut_vine").binding((Object)defaults.enableCutVine, () -> config.enableCutVine, newVal -> {
                config.enableCutVine = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableStopGrowingOpt = ConfigUtils.getGenericOption("enableStopGrowing", "stop_growing").binding((Object)defaults.enableStopGrowing, () -> config.enableStopGrowing, newVal -> {
                config.enableStopGrowing = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableShutupNameTagOpt = ConfigUtils.getGenericOption("enableShutupNameTag", "shutup_name_tag").binding((Object)defaults.enableShutupNameTag, () -> config.enableShutupNameTag, newVal -> {
                config.enableShutupNameTag = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableJukeboxLoopOpt = ConfigUtils.getGenericOption("enableJukeboxLoop").binding((Object)defaults.enableJukeboxLoop, () -> config.enableJukeboxLoop, newVal -> {
                config.enableJukeboxLoop = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableCakeDropOpt = ConfigUtils.getGenericOption("enableCakeDrop", "cake_drop").binding((Object)defaults.enableCakeDrop, () -> config.enableCakeDrop, newVal -> {
                config.enableCakeDrop = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableCeilingTorchOpt = ConfigUtils.getGenericOption("enableCeilingTorch", "ceiling_torch").binding((Object)defaults.enableCeilingTorch, () -> config.enableCeilingTorch, newVal -> {
                config.enableCeilingTorch = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableSafeLavaBucketOpt = ConfigUtils.getGenericOption("enableSafeLavaBucket").binding((Object)defaults.enableSafeLavaBucket, () -> config.enableSafeLavaBucket, newVal -> {
                config.enableSafeLavaBucket = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableAxolotlBucketFixOpt = ConfigUtils.getGenericOption("enableAxolotlBucketFix", "axolotl_bucket").binding((Object)defaults.enableAxolotlBucketFix, () -> config.enableAxolotlBucketFix, newVal -> {
                config.enableAxolotlBucketFix = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enablePlaceChestOnBoatOpt = ConfigUtils.getGenericOption("enablePlaceChestOnBoat").binding((Object)defaults.enablePlaceChestOnBoat, () -> config.enablePlaceChestOnBoat, newVal -> {
                config.enablePlaceChestOnBoat = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option enableNameTagDespawnOpt = ConfigUtils.getGenericOption("enableNameTagDespawn").binding((Object)defaults.enableNameTagDespawn, () -> config.enableNameTagDespawn, newVal -> {
                config.enableNameTagDespawn = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            return builder.title((Component)Component.translatable((String)"yacl3.config.enc_vanilla:config")).category(ConfigCategory.createBuilder().name(ConfigUtils.getCategoryName(QOL_CATEGORY)).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, VILLAGER_ATTRACTION_GROUP)).options(List.of(enableVillagerAttractionOpt, mainHandItemOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, ITEM_FRAME_GROUP)).options(List.of(enableInvisibleItemFrameOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, TORCH_HIT_GROUP)).options(List.of(enableTorchHitOpt, enableMobTorchHitOpt, torchHitFireChanceOpt, torchHitFireDurationOpt, extraTorchItemsOpt, extraSoulTorchItemsOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, TRAMPLING_PREVENTION_GROUP)).options(List.of(enableFarmlandTramplingPreventionOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, ANVIL_REPAIR_GROUP)).options(List.of(enableAnvilRepairOpt, anvilRepairMaterialOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, WATER_CONVERSION_GROUP)).options(List.of(enableWaterConversionOpt, enableMudConversionOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, BELL_PHANTOM_GROUP)).options(List.of(enableBellPhantomOpt, particleDurationOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, HIGHLIGHT_MOBS_GROUP)).options(List.of(enableHighlightMobsOpt, highlightDurationOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, SPONGE_PLACING_GROUP)).options(List.of(enableSpongePlacingOpt, enableSpongePlacingSneakingOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, HEALING_CAMPFIRE_GROUP)).options(List.of(enableHealingCampfireOpt, checkEveryTickOpt, healingRadiusOpt, effectDurationOpt, effectLevelOpt)).build()).group(OptionGroup.createBuilder().name(ConfigUtils.getGroupName(QOL_CATEGORY, OTHER_GROUP)).options(List.of(enableBlocksOnLilyPadOpt, enablePaintingSwitchingOpt, enableCutVineOpt, enableStopGrowingOpt, enableShutupNameTagOpt, enableJukeboxLoopOpt, enableCakeDropOpt, enableCeilingTorchOpt, enableWaterConversionOpt, enableSafeLavaBucketOpt, enableAxolotlBucketFixOpt, enablePlaceChestOnBoatOpt, enableNameTagDespawnOpt)).build()).build()).save(QolConfig::save);
        });
    }
}

