/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.config.client;

import com.euphony.enc_vanilla.config.categories.ClientConfig;
import com.euphony.enc_vanilla.config.categories.RecipesConfig;
import com.euphony.enc_vanilla.config.categories.ToolsConfig;
import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.config.client.widget.CategoryButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class EVConfigScreen
extends Screen {
    private final Screen parent;
    @Nullable
    private Screen qolConfigScreen = null;
    @Nullable
    private Screen toolsConfigScreen = null;
    @Nullable
    private Screen clientConfigScreen = null;
    @Nullable
    private Screen recipesConfigScreen = null;

    public EVConfigScreen(@Nullable Screen parent) {
        super((Component)Component.translatable((String)"yacl3.config.enc_vanilla:config"));
        this.parent = parent;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        assert (this.minecraft != null);
        context.drawCenteredString(this.minecraft.font, (Component)Component.translatable((String)"yacl3.config.enc_vanilla:config"), this.width / 2, 10, 0xFFFFFF);
    }

    protected void init() {
        super.init();
        int categoryButtonWidth = (this.width - 80) / 3;
        CategoryButton qolButton = new CategoryButton(30, 40, categoryButtonWidth, 20, (Component)Component.translatable((String)"yacl3.config.enc_vanilla:config.category.qol"), Items.IRON_PICKAXE.getDefaultInstance(), btn -> {
            if (this.qolConfigScreen == null) {
                this.qolConfigScreen = QolConfig.makeScreen().generateScreen((Screen)this);
            }
            this.minecraft.setScreen(this.qolConfigScreen);
        });
        CategoryButton toolsButton = new CategoryButton(30 + categoryButtonWidth + 10, 40, categoryButtonWidth, 20, (Component)Component.translatable((String)"yacl3.config.enc_vanilla:config.category.tools"), Items.AMETHYST_SHARD.getDefaultInstance(), btn -> {
            if (this.toolsConfigScreen == null) {
                this.toolsConfigScreen = ToolsConfig.makeScreen().generateScreen((Screen)this);
            }
            this.minecraft.setScreen(this.toolsConfigScreen);
        });
        CategoryButton clientButton = new CategoryButton(30 + (categoryButtonWidth + 10) * 2, 40, categoryButtonWidth, 20, (Component)Component.translatable((String)"yacl3.config.enc_vanilla:config.category.client"), Items.VINE.getDefaultInstance(), btn -> {
            if (this.clientConfigScreen == null) {
                this.clientConfigScreen = ClientConfig.makeScreen().generateScreen((Screen)this);
            }
            this.minecraft.setScreen(this.clientConfigScreen);
        });
        CategoryButton recipesButton = new CategoryButton(30, 70, categoryButtonWidth, 20, (Component)Component.translatable((String)"yacl3.config.enc_vanilla:config.category.recipes"), Items.ANVIL.getDefaultInstance(), btn -> {
            if (this.recipesConfigScreen == null) {
                this.recipesConfigScreen = RecipesConfig.makeScreen().generateScreen((Screen)this);
            }
            this.minecraft.setScreen(this.recipesConfigScreen);
        });
        int doneButtonWidth = this.width - 300;
        Button buttonWidget = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.minecraft.setScreen(this.parent)).bounds(this.width / 2 - doneButtonWidth / 2, this.height - 30, doneButtonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)qolButton);
        this.addRenderableWidget((GuiEventListener)toolsButton);
        this.addRenderableWidget((GuiEventListener)clientButton);
        this.addRenderableWidget((GuiEventListener)recipesButton);
        this.addRenderableWidget((GuiEventListener)buttonWidget);
    }
}

