/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.data;

import com.euphony.enc_vanilla.data.BlockStateGenerator;
import com.euphony.enc_vanilla.data.DataMapGenerator;
import com.euphony.enc_vanilla.data.LootGenerator;
import com.euphony.enc_vanilla.data.RegistryDataGenerator;
import com.euphony.enc_vanilla.data.loots.GlobalLootModifierGenerator;
import com.euphony.enc_vanilla.data.models.BlockModelGenerator;
import com.euphony.enc_vanilla.data.models.ItemModelGenerator;
import com.euphony.enc_vanilla.data.recipes.RecipeGenerator;
import com.euphony.enc_vanilla.data.tag.BlockTagGenerator;
import com.euphony.enc_vanilla.data.tag.ItemTagGenerator;
import com.euphony.enc_vanilla.data.tag.PaintingVariantTagGenerator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="enc_vanilla", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        RegistryDataGenerator datapackProvider = new RegistryDataGenerator(output, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(true, (DataProvider)new BlockModelGenerator(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new ItemModelGenerator(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)new PaintingVariantTagGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new BlockStateGenerator(output, existingFileHelper));
        generator.addProvider(true, (DataProvider)datapackProvider);
        BlockTagGenerator blockTagGenerator = new BlockTagGenerator(output, lookupProvider, existingFileHelper);
        generator.addProvider(true, (DataProvider)blockTagGenerator);
        generator.addProvider(true, (DataProvider)new ItemTagGenerator(output, lookupProvider, blockTagGenerator.contentsGetter(), existingFileHelper));
        generator.addProvider(true, (DataProvider)new GlobalLootModifierGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new LootGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new RecipeGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new DataMapGenerator(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Enchanting Vanilla"), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.empty())));
    }
}

