/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.data.models;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.euphony.enc_vanilla.common.init.EVItems;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    ExistingFileHelper existingFileHelper;

    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "enc_vanilla", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerModels() {
        int i;
        this.basicItem(EncVanilla.prefix("frog_bucket_active"));
        this.predicateItem((Item)EVItems.FROG_BUCKET_ITEM.get(), 1, "frog_bucket_active");
        for (i = 0; i < 16; ++i) {
            this.basicItem(EncVanilla.prefix("sculk_compass_" + String.format("%02d", i)));
        }
        for (i = 17; i < 32; ++i) {
            this.basicItem(EncVanilla.prefix("sculk_compass_" + i));
        }
        this.basicItem((Item)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get());
        this.basicItem((Item)EVItems.BIOME_CRYSTAL_ITEM.get());
        this.basicItem((Item)EVItems.FROZEN_BIOME_CRYSTAL_ITEM.get());
        this.basicItem((Item)EVItems.HEATED_BIOME_CRYSTAL_ITEM.get());
        this.basicItem(EncVanilla.prefix("axolotl_bucket_wild"));
        this.basicItem(EncVanilla.prefix("axolotl_bucket_gold"));
        this.basicItem(EncVanilla.prefix("axolotl_bucket_cyan"));
        this.basicItem(EncVanilla.prefix("axolotl_bucket_blue"));
        this.basicBlockItem(EVBlocks.CUT_VINE.asItem());
        this.basicBlockItem(EVBlocks.CUT_SUGAR_CANE.asItem());
        this.simpleVanillaBlockItem((Block)EVBlocks.COMPRESSED_SLIME_BLOCK.get(), "slime_block");
        this.simpleBlockItem((Block)EVBlocks.CEILING_TORCH.get());
        this.simpleBlockItem((Block)EVBlocks.CEILING_REDSTONE_TORCH.get());
        this.simpleBlockItem((Block)EVBlocks.CEILING_SOUL_TORCH.get());
    }

    public ItemModelBuilder basicBlockItem(Item item) {
        return this.basicBlockItem(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)));
    }

    public ItemModelBuilder basicBlockItem(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)item.getNamespace(), (String)("block/" + item.getPath())));
    }

    public ItemModelBuilder simpleVanillaBlockItem(Block block, String path) {
        return this.simpleVanillaBlockItem(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)), path);
    }

    public ItemModelBuilder simpleVanillaBlockItem(ResourceLocation block, String path) {
        return (ItemModelBuilder)this.withExistingParent(block.toString(), ResourceLocation.withDefaultNamespace((String)("block/" + path)));
    }

    protected ItemModelBuilder.OverrideBuilder predicateItem(Item item, int customModelData, String overrideModel) {
        return this.predicateItem(BuiltInRegistries.ITEM.getKey((Object)item), customModelData, overrideModel);
    }

    protected ItemModelBuilder.OverrideBuilder predicateItem(ResourceLocation item, int customModelData, String overrideModel) {
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", EncVanilla.prefix("item/" + item.getPath()))).override().predicate(ResourceLocation.withDefaultNamespace((String)"custom_model_data"), (float)customModelData).model((ModelFile)new ModelFile.ExistingModelFile(EncVanilla.prefix("item/" + overrideModel), this.existingFileHelper));
    }
}

