/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.data.recipes;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.common.condition.BoolConfigCondition;
import com.euphony.enc_vanilla.common.init.EVDataComponentTypes;
import com.euphony.enc_vanilla.common.init.EVItems;
import com.euphony.enc_vanilla.common.item.BiomeCrystalMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class RecipeGenerator
extends RecipeProvider {
    public RecipeGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
        this.addSpongeCampfireRecipes(recipeOutput.withConditions(new ICondition[]{new BoolConfigCondition("spongeCampfire")}));
        this.addSculkCompassRecipes(recipeOutput.withConditions(new ICondition[]{new BoolConfigCondition("sculkCompass")}));
        this.addBetterLodestoneRecipes(recipeOutput.withConditions(new ICondition[]{new BoolConfigCondition("betterLodestone")}));
    }

    protected void addSpongeCampfireRecipes(RecipeOutput recipeOutput) {
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.WET_SPONGE}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SPONGE, (float)0.15f, (int)600).unlockedBy("has_item", RecipeGenerator.has((ItemLike)Items.WET_SPONGE)).save(recipeOutput, "wet_sponge_to_sponge");
    }

    protected void addBetterLodestoneRecipes(RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.LODESTONE).pattern("SSS").pattern("S#S").pattern("SSS").define(Character.valueOf('S'), (ItemLike)Items.CHISELED_STONE_BRICKS).define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_item", RecipeGenerator.has((ItemLike)Items.IRON_INGOT)).save(recipeOutput, this.createKey("lodestone"));
    }

    protected void addSculkCompassRecipes(RecipeOutput recipeOutput) {
        ItemStack resultItem;
        ResourceKey<Biome> biome;
        List<Item> items;
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)EVItems.SCULK_COMPASS_ITEM.get()), (int)1).define(Character.valueOf('S'), (ItemLike)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get()).define(Character.valueOf('I'), (ItemLike)Items.ECHO_SHARD).define(Character.valueOf('A'), (ItemLike)Items.AMETHYST_SHARD).pattern("IAI").pattern("ISI").pattern("III").unlockedBy("has_item", RecipeGenerator.has((ItemLike)((ItemLike)EVItems.DAMAGED_SCULK_COMPASS_ITEM.get()))).save(recipeOutput, this.createKey("sculk_compass"));
        for (Map.Entry<List<Item>, ResourceKey<Biome>> entry : BiomeCrystalMap.getRecipeMap("HEATED").entrySet()) {
            items = entry.getKey();
            biome = entry.getValue();
            resultItem = EVItems.HEATED_BIOME_CRYSTAL_ITEM.toStack();
            resultItem.set(EVDataComponentTypes.BIOME, biome);
            this.shapeless(RecipeCategory.MISC, resultItem, recipeOutput, items, "heated_biome_crystal_" + biome.location().getNamespace() + "_" + biome.location().getPath(), (Item)EVItems.HEATED_BIOME_CRYSTAL_ITEM.get());
        }
        for (Map.Entry<List<Item>, ResourceKey<Biome>> entry : BiomeCrystalMap.getRecipeMap("NORMAL").entrySet()) {
            items = entry.getKey();
            biome = entry.getValue();
            resultItem = EVItems.BIOME_CRYSTAL_ITEM.toStack();
            resultItem.set(EVDataComponentTypes.BIOME, biome);
            this.shapeless(RecipeCategory.MISC, resultItem, recipeOutput, items, "biome_crystal_" + biome.location().getNamespace() + "_" + biome.location().getPath(), (Item)EVItems.BIOME_CRYSTAL_ITEM.get());
        }
        for (Map.Entry<List<Item>, ResourceKey<Biome>> entry : BiomeCrystalMap.getRecipeMap("FROZEN").entrySet()) {
            items = entry.getKey();
            biome = entry.getValue();
            resultItem = EVItems.FROZEN_BIOME_CRYSTAL_ITEM.toStack();
            resultItem.set(EVDataComponentTypes.BIOME, biome);
            this.shapeless(RecipeCategory.MISC, resultItem, recipeOutput, items, "frozen_biome_crystal_" + biome.location().getNamespace() + "_" + biome.location().getPath(), (Item)EVItems.FROZEN_BIOME_CRYSTAL_ITEM.get());
        }
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemStack resultItem, RecipeOutput recipeOutput, List<Item> items, String key, Item ... additionalItems) {
        ShapelessRecipeBuilder shapeless = ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemStack)resultItem);
        for (Item item : additionalItems) {
            shapeless.requires((ItemLike)item).unlockedBy("has_item", RecipeGenerator.has((ItemLike)item));
        }
        for (Item item : items) {
            shapeless.requires((ItemLike)item).unlockedBy("has_item", RecipeGenerator.has((ItemLike)item));
        }
        shapeless.save(recipeOutput, this.createKey(key));
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemStack resultItem, RecipeOutput recipeOutput, List<Item> items, String key) {
        ShapelessRecipeBuilder shapeless = ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemStack)resultItem);
        for (Item item : items) {
            shapeless.requires((ItemLike)item).unlockedBy("has_item", RecipeGenerator.has((ItemLike)item));
        }
        shapeless.save(recipeOutput, this.createKey(key));
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemLike resultItem, RecipeOutput recipeOutput, List<Item> items, String key) {
        this.shapeless(recipeCategory, resultItem, 1, recipeOutput, items, key);
    }

    protected void shapeless(RecipeCategory recipeCategory, ItemLike resultItem, int count, RecipeOutput recipeOutput, List<Item> items, String key) {
        ShapelessRecipeBuilder shapeless = ShapelessRecipeBuilder.shapeless((RecipeCategory)recipeCategory, (ItemLike)resultItem, (int)count);
        for (Item item : items) {
            shapeless.requires((ItemLike)item).unlockedBy("has_item", RecipeGenerator.has((ItemLike)item));
        }
        shapeless.save(recipeOutput, this.createKey(key));
    }

    protected ResourceLocation createKey(String name) {
        return EncVanilla.prefix(name);
    }
}

