/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="enc_vanilla")
public class CakeDropEvent {
    @SubscribeEvent
    public static void process(BlockEvent.BreakEvent event) {
        int bites;
        if (!((QolConfig)QolConfig.HANDLER.instance()).enableCakeDrop) {
            return;
        }
        if (event.getPlayer().isCreative()) {
            return;
        }
        BlockState state = event.getState();
        Level level = event.getPlayer().level();
        BlockPos pos = event.getPos();
        if (state.is(BlockTags.CANDLE_CAKES)) {
            CakeDropEvent.dropCake(level, pos);
            return;
        }
        if (state.hasProperty((Property)BlockStateProperties.BITES) && (bites = ((Integer)state.getValue((Property)BlockStateProperties.BITES)).intValue()) == 0) {
            CakeDropEvent.dropCake(level, pos);
        }
    }

    private static void dropCake(Level level, BlockPos pos) {
        Containers.dropItemStack((Level)level, (double)pos.getX(), (double)((double)pos.getY() + 0.5), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)Items.CAKE));
    }
}

