/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events;

import com.euphony.enc_vanilla.common.init.EVBlocks;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="enc_vanilla")
public class CeilingTorchClient {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ImmutableMap placeEntries = ImmutableMap.of((Object)Items.TORCH, (Object)((Block)EVBlocks.CEILING_TORCH.get()), (Object)Items.REDSTONE_TORCH, (Object)((Block)EVBlocks.CEILING_REDSTONE_TORCH.get()), (Object)Items.SOUL_TORCH, (Object)((Block)EVBlocks.CEILING_SOUL_TORCH.get()));
        if (!event.getEntity().isSpectator()) {
            ItemStack stack;
            BlockPos pos = event.getPos();
            Direction face = event.getFace();
            BlockPos placeAt = pos.relative(face);
            Level level = event.getLevel();
            if (face == Direction.DOWN && (level.isEmptyBlock(placeAt) || !level.getFluidState(placeAt).isEmpty()) && placeEntries.containsKey((stack = event.getItemStack()).getItem())) {
                CeilingTorchClient.placeTorch(event.getEntity(), event.getHand(), stack, placeAt, level, ((Block)placeEntries.get(stack.getItem())).defaultBlockState());
            }
        }
    }

    public static void placeTorch(Player player, InteractionHand hand, ItemStack stack, BlockPos pos, Level level, BlockState state) {
        if (state.canSurvive((LevelReader)level, pos)) {
            level.setBlockAndUpdate(pos, state);
            SoundType soundType = state.getBlock().getSoundType(state, (LevelReader)level, pos, (Entity)player);
            level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundType.getPlaceSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
            player.swing(hand);
            stack.consume(1, (LivingEntity)player);
        }
    }
}

