/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.utils.Utils;
import java.util.ArrayList;
import java.util.Optional;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="enc_vanilla")
public class SwitchPaintingEvent {
    @SubscribeEvent
    public static void entityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enablePaintingSwitching) {
            return;
        }
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        InteractionHand hand = event.getHand();
        if (hand != InteractionHand.OFF_HAND) {
            return;
        }
        Player player = event.getEntity();
        if (!player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty()) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity.getType() == EntityType.PAINTING) {
            Painting painting = (Painting)entity;
            ArrayList<Holder> list = new ArrayList<Holder>();
            level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(list::add);
            if (!list.isEmpty()) {
                list.removeIf(p_344343_ -> {
                    painting.setVariant(p_344343_);
                    return !painting.survives();
                });
                list.remove(painting.getVariant());
                if (!list.isEmpty()) {
                    int i = list.stream().mapToInt(SwitchPaintingEvent::variantArea).max().orElse(0);
                    list.removeIf(p_218883_ -> SwitchPaintingEvent.variantArea((Holder<PaintingVariant>)p_218883_) < i);
                    Optional optional = Util.getRandomSafe(list, (RandomSource)painting.getRandom());
                    if (optional.isPresent()) {
                        painting.setVariant((Holder)optional.get());
                        player.swing(hand);
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void blockInteract(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.isClientSide || !Utils.isModLoaded("fastpaintings")) {
            return;
        }
        InteractionHand hand = event.getHand();
        if (hand != InteractionHand.OFF_HAND) {
            return;
        }
        Player player = event.getEntity();
        if (!player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty()) {
            return;
        }
        BlockPos blockPos = event.getPos();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof PaintingBlockEntity) {
            ResourceLocation variantResourceLocation;
            PaintingBlockEntity painting = (PaintingBlockEntity)blockEntity;
            CompoundTag tag = painting.getUpdateTag((HolderLookup.Provider)level.registryAccess());
            String rawVariantResourceLocation = tag.getString("variant");
            try {
                variantResourceLocation = ResourceLocation.parse((String)rawVariantResourceLocation);
            }
            catch (ResourceLocationException ex) {
                return;
            }
            Registry paintingVariantRegistry = level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT);
            Optional optionalPaintingVariant = paintingVariantRegistry.getOptional(variantResourceLocation);
            if (optionalPaintingVariant.isPresent()) {
                Holder paintingVariantHolder = paintingVariantRegistry.wrapAsHolder((Object)((PaintingVariant)optionalPaintingVariant.get()));
                ArrayList<Holder> list = new ArrayList<Holder>();
                level.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(PaintingVariantTags.PLACEABLE).forEach(list::add);
                if (!list.isEmpty()) {
                    list.remove(paintingVariantHolder);
                    if (!list.isEmpty()) {
                        int width = ((PaintingVariant)paintingVariantHolder.value()).width();
                        int height = ((PaintingVariant)paintingVariantHolder.value()).height();
                        list.removeIf(p_218883_ -> ((PaintingVariant)p_218883_.value()).width() != width || ((PaintingVariant)p_218883_.value()).height() != height);
                        Optional optional = Util.getRandomSafe(list, (RandomSource)RandomSource.create());
                        optional.ifPresent(arg_0 -> ((PaintingBlockEntity)painting).setVariant(arg_0));
                        level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                        Direction dir = (Direction)painting.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                        for (int x = 0; x < width; ++x) {
                            for (int y = 0; y < height; ++y) {
                                Painting painting1;
                                BlockPos pos;
                                BlockPos newPos = blockPos.below(y).relative(dir.getCounterClockWise(), x);
                                if (!optional.isPresent() || (pos = SwitchPaintingEvent.getBlockPos(painting1 = new Painting(level, newPos, dir, (Holder)optional.get()), dir)).getX() != blockPos.getX() || pos.getZ() != blockPos.getZ() || pos.getY() != blockPos.getY()) continue;
                                level.addFreshEntity((Entity)painting1);
                                player.swing(hand);
                                event.setCanceled(true);
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @NotNull
    private static BlockPos getBlockPos(Painting painting1, Direction dir) {
        AABB bb = painting1.getBoundingBox();
        return switch (dir) {
            case Direction.SOUTH -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.maxZ);
            case Direction.WEST -> BlockPos.containing((double)bb.minX, (double)(bb.maxY - 0.5), (double)bb.minZ);
            case Direction.EAST -> BlockPos.containing((double)bb.maxX, (double)(bb.maxY - 0.5), (double)(bb.maxZ - 0.5));
            default -> BlockPos.containing((double)(bb.maxX - 0.5), (double)(bb.maxY - 0.5), (double)bb.minZ);
        };
    }

    private static int variantArea(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.value()).area();
    }
}

