/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.events;

import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import com.euphony.enc_vanilla.utils.ItemUtils;
import com.euphony.enc_vanilla.utils.Utils;
import it.crystalnest.soul_fire_d.api.FireManager;
import it.crystalnest.soul_fire_d.api.type.FireTyped;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber
public final class TorchHitEvent {
    private TorchHitEvent() {
    }

    @SubscribeEvent
    public static void handle(LivingIncomingDamageEvent event) {
        if (!((QolConfig)QolConfig.HANDLER.instance()).enableTorchHit) {
            return;
        }
        Entity entity = event.getSource().getEntity();
        Entity directEntity = event.getSource().getDirectEntity();
        LivingEntity target = event.getEntity();
        if (entity instanceof LivingEntity) {
            InteractionHand interactionHand;
            LivingEntity attacker = (LivingEntity)entity;
            if (entity.equals((Object)directEntity) && !entity.level().isClientSide && !entity.isSpectator() && TorchHitEvent.canAttack(attacker, target) && (interactionHand = TorchHitEvent.getInteractionHand(attacker)) != null && !target.fireImmune()) {
                ItemStack item = attacker.getItemInHand(interactionHand);
                if (interactionHand == InteractionHand.MAIN_HAND) {
                    TorchHitEvent.attack((Entity)target, item);
                }
            }
        }
    }

    private static void attack(Entity target, ItemStack item) {
        double seconds = TorchHitEvent.getFireSeconds(item, target, ((QolConfig)QolConfig.HANDLER.instance()).torchHitFireDuration);
        if (seconds > 0.0) {
            if (Utils.isModLoaded("soul_fire_d")) {
                TorchHitEvent.setOnFire(item, target, seconds);
            } else {
                target.igniteForSeconds((float)seconds);
            }
        }
    }

    private static double getFireSeconds(ItemStack item, Entity target, double seconds) {
        if (Math.random() * 100.0 < (double)((QolConfig)QolConfig.HANDLER.instance()).torchHitFireChance) {
            return seconds;
        }
        return 0.0;
    }

    @Nullable
    private static InteractionHand getInteractionHand(LivingEntity attacker) {
        if (TorchHitEvent.isTorch(attacker.getMainHandItem())) {
            return InteractionHand.MAIN_HAND;
        }
        if (TorchHitEvent.isTorch(attacker.getOffhandItem())) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isTorch(ItemStack item) {
        return item.is(Items.TORCH) || ((QolConfig)QolConfig.HANDLER.instance()).extraTorchItems.contains(ItemUtils.getKey(item.getItem()).toString()) || TorchHitEvent.isSoulTorch(item);
    }

    private static boolean isSoulTorch(ItemStack item) {
        return item.is(Items.SOUL_TORCH) || ((QolConfig)QolConfig.HANDLER.instance()).extraSoulTorchItems.contains(ItemUtils.getKey(item.getItem()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof Player)) {
            if (!((QolConfig)QolConfig.HANDLER.instance()).enableMobTorchHit) return false;
        }
        if (!attacker.canAttack(target)) return false;
        if (!(attacker instanceof Player)) return true;
        Player attackerPlayer = (Player)attacker;
        if (!(target instanceof Player)) return true;
        Player targetPlayer = (Player)target;
        if (!attackerPlayer.canHarmPlayer(targetPlayer)) return false;
        return true;
    }

    public static void setOnFire(ItemStack item, Entity entity, double seconds) {
        StandingAndWallBlockItem torch;
        Item item2 = item.getItem();
        if (item2 instanceof StandingAndWallBlockItem && (item2 = (torch = (StandingAndWallBlockItem)item2).getBlock()) instanceof FireTyped) {
            FireTyped fireTypedTorch = (FireTyped)item2;
            FireManager.setOnFire((Entity)entity, (float)((float)seconds), (ResourceLocation)fireTypedTorch.getFireType());
        } else if (TorchHitEvent.isSoulTorch(item)) {
            FireManager.setOnFire((Entity)entity, (float)((float)seconds), (ResourceLocation)FireManager.SOUL_FIRE_TYPE);
        } else {
            FireManager.setOnFire((Entity)entity, (float)((float)seconds), (ResourceLocation)FireManager.DEFAULT_FIRE_TYPE);
        }
    }
}

