/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.common.init.EVItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.event.EventHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmallFireball.class})
public abstract class SmallFireballMixin
extends Fireball {
    public SmallFireballMixin(EntityType<? extends Fireball> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onHitEntityInject(EntityHitResult result, CallbackInfo ci) {
        ItemEntity item;
        Entity entity = result.getEntity();
        if (entity instanceof ItemEntity && (item = (ItemEntity)entity).getItem().is(EVItems.BIOME_CRYSTAL_ITEM)) {
            item.setItem(EVItems.HEATED_BIOME_CRYSTAL_ITEM.toStack());
            ci.cancel();
        }
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onHitBlockInject(BlockHitResult result, CallbackInfo ci) {
        Entity entity;
        if (!(this.level().isClientSide || (entity = this.getOwner()) instanceof Mob && !EventHooks.canEntityGrief((Level)this.level(), (Entity)entity))) {
            BlockPos blockpos = result.getBlockPos().relative(result.getDirection());
            Level level = this.level();
            AABB checkBox = new AABB(blockpos).inflate(0.5, 0.0, 0.5);
            if (level.isEmptyBlock(blockpos)) {
                List items = level.getEntitiesOfClass(ItemEntity.class, checkBox);
                for (ItemEntity item : items) {
                    if (!item.getItem().is(EVItems.BIOME_CRYSTAL_ITEM)) continue;
                    item.discard();
                    Containers.dropItemStack((Level)level, (double)blockpos.getX(), (double)((double)blockpos.getY() + 0.5), (double)blockpos.getZ(), (ItemStack)EVItems.HEATED_BIOME_CRYSTAL_ITEM.toStack());
                    ci.cancel();
                }
            }
        }
    }
}

