/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.mixin;

import com.euphony.enc_vanilla.common.entity.DoubleHandedTemptGoal;
import com.euphony.enc_vanilla.config.categories.qol.QolConfig;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Unique
    private DoubleHandedTemptGoal enc_vanilla$villagersAttractedGoal;
    @Unique
    private boolean enc_vanilla$villagersAttracted;
    @Unique
    private ItemStack OMINOUS_BANNER = Items.WHITE_BANNER.getDefaultInstance();

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
        HolderLookup.RegistryLookup bannerPattern = level.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN);
        this.OMINOUS_BANNER.set(DataComponents.HIDE_ADDITIONAL_TOOLTIP, (Object)Unit.INSTANCE);
        this.OMINOUS_BANNER.set(DataComponents.RARITY, (Object)Rarity.UNCOMMON);
        this.OMINOUS_BANNER.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"{\"translate\":\"block.minecraft.ominous_banner\"}"));
        this.OMINOUS_BANNER.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)bannerPattern.getOrThrow(BannerPatterns.RHOMBUS_MIDDLE), DyeColor.CYAN).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_BOTTOM), DyeColor.LIGHT_GRAY).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_CENTER), DyeColor.GRAY).add((Holder)bannerPattern.getOrThrow(BannerPatterns.BORDER), DyeColor.LIGHT_GRAY).add((Holder)bannerPattern.getOrThrow(BannerPatterns.STRIPE_MIDDLE), DyeColor.BLACK).add((Holder)bannerPattern.getOrThrow(BannerPatterns.HALF_HORIZONTAL), DyeColor.LIGHT_GRAY).add((Holder)bannerPattern.getOrThrow(BannerPatterns.CIRCLE_MIDDLE), DyeColor.LIGHT_GRAY).add((Holder)bannerPattern.getOrThrow(BannerPatterns.BORDER), DyeColor.BLACK).build());
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/npc/VillagerType;)V"}, at={@At(value="RETURN")})
    private void init(EntityType<? extends Villager> entityType, Level level, VillagerType villagerType, CallbackInfo ci) {
        this.enc_vanilla$villagersAttractedGoal = new DoubleHandedTemptGoal((PathfinderMob)this, 0.5, (Predicate<ItemStack>)Ingredient.of((ItemLike[])new ItemLike[]{((QolConfig)QolConfig.HANDLER.instance()).mainHandItem}), (Predicate<ItemStack>)Ingredient.of((ItemStack[])new ItemStack[]{this.OMINOUS_BANNER}), false);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void checkVillagersAttracted(CallbackInfo ci) {
        boolean configEnabled = ((QolConfig)QolConfig.HANDLER.instance()).enableVillagerAttraction;
        if (!this.enc_vanilla$villagersAttracted && configEnabled) {
            if (!this.enc_vanilla$villagersAttractedGoal.canUse()) {
                this.enc_vanilla$villagersAttractedGoal = new DoubleHandedTemptGoal((PathfinderMob)this, 0.5, (Predicate<ItemStack>)Ingredient.of((ItemLike[])new ItemLike[]{((QolConfig)QolConfig.HANDLER.instance()).mainHandItem}), (Predicate<ItemStack>)Ingredient.of((ItemStack[])new ItemStack[]{this.OMINOUS_BANNER}), false);
            }
            this.goalSelector.addGoal(0, (Goal)this.enc_vanilla$villagersAttractedGoal);
            this.enc_vanilla$villagersAttracted = true;
        } else if (this.enc_vanilla$villagersAttracted && !configEnabled) {
            this.goalSelector.removeGoal((Goal)this.enc_vanilla$villagersAttractedGoal);
            this.enc_vanilla$villagersAttracted = false;
        }
    }
}

