/*
 * Decompiled with CFR 0.152.
 */
package com.euphony.enc_vanilla.utils.config;

import com.euphony.enc_vanilla.EncVanilla;
import com.euphony.enc_vanilla.utils.config.DescComponent;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;

public class ConfigUtils {
    public static final int IMG_WIDTH = 1920;
    public static final int IMG_HEIGHT = 991;
    public static final OptionFlag RESOURCE_RELOAD = client -> {
        IntegratedServer server;
        if (client.hasSingleplayerServer() && (server = client.getSingleplayerServer()) != null) {
            PackRepository packrepository = server.getPackRepository();
            Collection collection = packrepository.getSelectedIds();
            server.reloadResources(collection);
        }
    };

    public static ListOption.Builder<String> getListGroupOption(String name) {
        return ListOption.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, null)}).build());
    }

    public static ButtonOption.Builder getButtonOption(String name) {
        return ButtonOption.createBuilder().name(ConfigUtils.getButtonOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, null)}).build());
    }

    public static <T> Option.Builder<T> getGenericOption(String name) {
        return ConfigUtils.getGenericOption(name, (DescComponent)null);
    }

    public static <T> Option.Builder<T> getGenericOption(String name, @Nullable DescComponent descComponent) {
        return Option.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, descComponent)}).build());
    }

    public static <T> Option.Builder<T> getGenericOption(String name, String image) {
        return ConfigUtils.getGenericOption(name, image, null);
    }

    public static <T> Option.Builder<T> getGenericOption(String name, String image, @Nullable DescComponent descComponent) {
        return Option.createBuilder().name(ConfigUtils.getOptionName(name)).description(OptionDescription.createBuilder().text(new Component[]{ConfigUtils.getDesc(name, descComponent)}).image(ConfigUtils.getImage(image), 1920, 991).build());
    }

    public static Component getCategoryName(String category) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.category.%s", "enc_vanilla", category));
    }

    public static Component getGroupName(String category, String group) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.category.%s.group.%s", "enc_vanilla", category, group));
    }

    private static Component getButtonOptionName(String option) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.%s.button", "enc_vanilla", option));
    }

    private static Component getOptionName(String option) {
        return Component.translatable((String)String.format("yacl3.config.%s:config.%s", "enc_vanilla", option));
    }

    private static Component getDesc(String option, @Nullable DescComponent descComponent) {
        MutableComponent component = Component.translatable((String)String.format("yacl3.config.%s:config.%s.desc", "enc_vanilla", option));
        if (descComponent != null) {
            component.append((Component)Component.literal((String)"\n\n").append(descComponent.getText()));
        }
        return component;
    }

    private static ResourceLocation getImage(String name) {
        return EncVanilla.prefix(String.format("config/%s.png", name));
    }
}

