/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.api;

import dev.imabad.theatrical.lighting.LightManager;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public interface DynamicLightProvider {
    public BlockPos getOwnerPos();

    public Vector3f getLightPos();

    public Level getLightWorld();

    default public boolean isLightEnabled() {
        return LightManager.containsLightSource(this);
    }

    default public void setLightEnabled(boolean enabled) {
        this.resetLight();
        if (enabled) {
            LightManager.addLightSource(this);
        } else {
            LightManager.removeLightSource(this);
        }
    }

    public void resetLight();

    public int getLightLuminance();

    public void lightTick();

    public boolean shouldUpdateLight();

    public boolean updateDynamicLight(LevelRenderer var1);

    public void scheduleTrackedChunksRebuild(LevelRenderer var1);

    public int getLightColour();

    public float getLightSpread();
}

