/*
 * Decompiled with CFR 0.152.
 */
package dev.imabad.theatrical.blockentities.interfaces;

import dev.imabad.theatrical.blockentities.BlockEntities;
import dev.imabad.theatrical.blockentities.ClientSyncBlockEntity;
import dev.imabad.theatrical.config.TheatricalConfig;
import dev.imabad.theatrical.dmx.DMXNetwork;
import dev.imabad.theatrical.dmx.DMXNetworkData;
import dev.imabad.theatrical.util.UUIDUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ArtNetInterfaceBlockEntity
extends ClientSyncBlockEntity {
    private int subnet;
    private int universe;
    private int tickTimer = 0;
    private String ip = "127.0.0.1";
    private UUID networkId = UUIDUtil.NULL;

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T be) {
        ArtNetInterfaceBlockEntity tile = (ArtNetInterfaceBlockEntity)be;
    }

    public ArtNetInterfaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntities.ART_NET_INTERFACE.get(), blockPos, blockState);
    }

    @Override
    public void write(CompoundTag compoundTag) {
        compoundTag.m_128359_("ip", this.ip);
        compoundTag.m_128405_("subnet", this.subnet);
        compoundTag.m_128405_("universe", this.universe);
        if (this.networkId != null) {
            compoundTag.m_128362_("networkId", this.networkId);
        }
    }

    @Override
    public void read(CompoundTag compoundTag) {
        this.ip = compoundTag.m_128461_("ip");
        this.subnet = compoundTag.m_128451_("subnet");
        this.universe = compoundTag.m_128451_("universe");
        if (compoundTag.m_128441_("networkId")) {
            this.networkId = compoundTag.m_128342_("networkId");
        }
    }

    public void update(byte[] data) {
        DMXNetwork dmxData;
        if (this.f_58857_ != null && this.f_58857_.m_7654_() != null && (dmxData = DMXNetworkData.getInstance((Level)this.f_58857_.m_7654_().m_129783_()).getNetwork(this.networkId)) != null) {
            dmxData.getConsumersInRange(this.universe, this.m_58899_(), TheatricalConfig.INSTANCE.COMMON.wirelessDMXRadius).forEach(dmxConsumer -> dmxConsumer.consume(data));
        }
    }

    public boolean hasReceivedPacket() {
        return false;
    }

    public long getLastReceivedPacket() {
        return 0L;
    }

    public int getUniverse() {
        return this.universe;
    }

    public String getIp() {
        return this.ip;
    }

    public void updateConfig(String ipAddress, int dmxUniverse) {
        this.ip = ipAddress;
        this.universe = dmxUniverse;
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }
}

